/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.jwtvalidatorvertx.impl;

import com.google.common.collect.ImmutableSet;
import io.vertx.core.json.JsonObject;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.spudsoft.jwtvalidatorvertx.JwkBuilder;

public class ECJwkBuilder
extends JwkBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ECJwkBuilder.class);
    private static final String KTY = "EC";
    private static final Set<String> VALID_ALGS = ImmutableSet.builder().add((Object)"ES256").add((Object)"ES384").add((Object)"ES512").build();

    @Override
    public boolean canHandleKey(PublicKey key) {
        return key instanceof ECPublicKey;
    }

    private static String oidToCurve(String oid) {
        switch (oid) {
            case "1.2.840.10045.3.1.7": {
                return "P-256";
            }
            case "1.3.132.0.34": {
                return "P-384";
            }
            case "1.3.132.0.35": {
                return "P-521";
            }
        }
        logger.warn("Unrecognised OID passed in: {}", (Object)oid);
        throw new IllegalArgumentException("Unknown OID");
    }

    private static byte[] coordinateToByteArray(int fieldSize, BigInteger coordinate) {
        byte[] coordinateByteArray = coordinate.toByteArray();
        int fullSize = (int)Math.ceil((double)fieldSize / 8.0);
        if (fullSize > coordinateByteArray.length) {
            byte[] fullSizeCoordinateByteArray = new byte[fullSize];
            System.arraycopy(coordinateByteArray, 0, fullSizeCoordinateByteArray, fullSize - coordinateByteArray.length, coordinateByteArray.length);
            return fullSizeCoordinateByteArray;
        }
        return coordinateByteArray;
    }

    @Override
    public JsonObject toJson(String kid, String algorithm, PublicKey publicKey) throws InvalidParameterSpecException, NoSuchAlgorithmException {
        ECPublicKey key = (ECPublicKey)publicKey;
        JsonObject json = new JsonObject();
        if (!VALID_ALGS.contains(algorithm)) {
            logger.warn("The algorithm {} is not in {}", (Object)algorithm, VALID_ALGS);
            throw new NoSuchAlgorithmException(algorithm);
        }
        json.put("alg", (Object)algorithm);
        json.put("kid", (Object)kid);
        json.put("kty", (Object)KTY);
        AlgorithmParameters params = AlgorithmParameters.getInstance(KTY);
        params.init(key.getParams());
        String oid = params.getParameterSpec(ECGenParameterSpec.class).getName();
        String curve = ECJwkBuilder.oidToCurve(oid);
        json.put("crv", (Object)curve);
        int fieldSize = key.getParams().getCurve().getField().getFieldSize();
        json.put("x", (Object)B64ENCODER.encodeToString(ECJwkBuilder.coordinateToByteArray(fieldSize, key.getW().getAffineX())));
        json.put("y", (Object)B64ENCODER.encodeToString(ECJwkBuilder.coordinateToByteArray(fieldSize, key.getW().getAffineY())));
        return json;
    }
}

