/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.jwtvalidatorvertx.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Bytes;
import io.vertx.core.json.JsonObject;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.EdECPublicKey;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.spudsoft.jwtvalidatorvertx.JwkBuilder;

public class EdECJwkBuilder
extends JwkBuilder {
    private static final Logger logger = LoggerFactory.getLogger(EdECJwkBuilder.class);
    private static final Set<String> VALID_ALGS = ImmutableSet.builder().add((Object)"EdDSA").build();
    private static final String KTY = "OKP";

    @Override
    public boolean canHandleKey(PublicKey key) {
        return key instanceof EdECPublicKey;
    }

    @Override
    public JsonObject toJson(String kid, String algorithm, PublicKey publicKey) throws NoSuchAlgorithmException {
        EdECPublicKey key = (EdECPublicKey)publicKey;
        JsonObject json = new JsonObject();
        if (!VALID_ALGS.contains(algorithm)) {
            logger.warn("The algorithm {} is not in {}", (Object)algorithm, VALID_ALGS);
            throw new NoSuchAlgorithmException(algorithm);
        }
        json.put("alg", (Object)algorithm);
        json.put("kid", (Object)kid);
        json.put("kty", (Object)KTY);
        json.put("crv", (Object)key.getParams().getName());
        BigInteger y = key.getPoint().getY();
        byte[] arr = y.toByteArray();
        Bytes.reverse((byte[])arr, (int)0, (int)arr.length);
        json.put("x", (Object)B64ENCODER.encodeToString(arr));
        return json;
    }
}

