/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.jwtvalidatorvertx.impl;

import com.google.common.base.Strings;
import java.io.File;
import java.nio.file.Files;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.spudsoft.jwtvalidatorvertx.IssuerAcceptabilityHandler;

public class IssuerAcceptabilityHandlerImpl
implements IssuerAcceptabilityHandler {
    private static final Logger logger = LoggerFactory.getLogger(IssuerAcceptabilityHandlerImpl.class);
    private final List<Pattern> acceptableIssuerRegexes;
    private final File acceptableIssuersFile;
    private final long pollPeriodMs;
    private final Object lock = new Object();
    private long lastFileCheck = 0L;
    private Set<String> acceptableIssuers = Collections.emptySet();
    private long fileLastModified = 0L;

    @Override
    public void validate() throws IllegalArgumentException {
        if (this.acceptableIssuerRegexes.isEmpty() && this.acceptableIssuersFile == null) {
            throw new IllegalArgumentException("No acceptable issuers configured - neither regular expressions nor file configured");
        }
    }

    public IssuerAcceptabilityHandlerImpl(List<String> acceptableIssuerRegexes, String acceptableIssuersFile, Duration pollPeriod) {
        this.acceptableIssuerRegexes = acceptableIssuerRegexes == null ? Collections.emptyList() : acceptableIssuerRegexes.stream().map(re -> {
            if (re == null || re.isBlank()) {
                logger.warn("Null or empty pattern cannot be used: ", re);
                return null;
            }
            try {
                Pattern pattern = Pattern.compile(re);
                logger.trace("Compiled acceptable issuer regex as {}", (Object)pattern.pattern());
                return pattern;
            }
            catch (Throwable ex) {
                logger.warn("The pattern \"{}\" cannot be compiled: ", re, (Object)ex);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        this.acceptableIssuersFile = Strings.isNullOrEmpty((String)acceptableIssuersFile) ? null : new File(acceptableIssuersFile);
        this.pollPeriodMs = pollPeriod.toMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAcceptable(String issuer) {
        Set<String> localAcceptableIssuers;
        long now;
        boolean shouldUpdate = false;
        if (Strings.isNullOrEmpty((String)issuer)) {
            logger.warn("Invalid issuer: {}", (Object)(issuer == null ? "<null>" : "<blank>"));
            return false;
        }
        Iterator<Pattern> iterator = this.lock;
        synchronized (iterator) {
            now = System.currentTimeMillis();
            if (this.lastFileCheck + this.pollPeriodMs < now) {
                this.lastFileCheck = now;
                shouldUpdate = true;
            }
            localAcceptableIssuers = this.acceptableIssuers;
        }
        if (shouldUpdate) {
            this.checkFile(now);
            iterator = this.lock;
            synchronized (iterator) {
                localAcceptableIssuers = this.acceptableIssuers;
            }
        }
        if (localAcceptableIssuers.contains(issuer)) {
            return true;
        }
        for (Pattern acceptableIssuer : this.acceptableIssuerRegexes) {
            if (!acceptableIssuer.matcher(issuer).matches()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFile(long now) {
        block16: {
            if (this.acceptableIssuersFile == null) {
                return;
            }
            try {
                if (this.acceptableIssuersFile.isFile()) {
                    long lastModNew = this.acceptableIssuersFile.lastModified();
                    if (lastModNew == this.fileLastModified || lastModNew + this.pollPeriodMs >= now) break block16;
                    this.fileLastModified = lastModNew;
                    HashSet<String> newSet = new HashSet<String>();
                    try (Stream<String> stream = Files.lines(this.acceptableIssuersFile.toPath());){
                        stream.forEach(l -> {
                            if (l != null && !(l = l.trim()).isEmpty()) {
                                newSet.add((String)l);
                            }
                        });
                    }
                    Object object = this.lock;
                    synchronized (object) {
                        this.acceptableIssuers = newSet;
                        break block16;
                    }
                }
                Object lastModNew = this.lock;
                synchronized (lastModNew) {
                    this.acceptableIssuers = Collections.emptySet();
                }
            }
            catch (Throwable ex) {
                logger.error("Error loading acceptable issuers file: ", ex);
            }
        }
    }
}

