/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.jwtvalidatorvertx.impl;

import com.google.common.base.Strings;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.impl.jose.JWK;
import io.vertx.ext.web.client.WebClient;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.spudsoft.jwtvalidatorvertx.DiscoveryData;
import uk.co.spudsoft.jwtvalidatorvertx.IssuerAcceptabilityHandler;
import uk.co.spudsoft.jwtvalidatorvertx.JsonWebKeySetOpenIdDiscoveryHandler;
import uk.co.spudsoft.jwtvalidatorvertx.impl.AsyncLoadingCache;
import uk.co.spudsoft.jwtvalidatorvertx.impl.OpenIdHelper;

public class JWKSOpenIdDiscoveryHandlerImpl
implements JsonWebKeySetOpenIdDiscoveryHandler {
    private static final Logger logger = LoggerFactory.getLogger(JWKSOpenIdDiscoveryHandlerImpl.class);
    private final AsyncLoadingCache<String, DiscoveryData> discoveryDataCache;
    private final Map<String, AsyncLoadingCache<String, JWK>> kidCache;
    private final IssuerAcceptabilityHandler issuerAcceptabilityHandler;
    private final OpenIdHelper openIdHelper;

    public JWKSOpenIdDiscoveryHandlerImpl(WebClient webClient, IssuerAcceptabilityHandler issuerAcceptabilityHandler, Duration defaultJwkCacheDuration) {
        this.issuerAcceptabilityHandler = issuerAcceptabilityHandler;
        issuerAcceptabilityHandler.validate();
        this.discoveryDataCache = new AsyncLoadingCache();
        this.kidCache = new HashMap<String, AsyncLoadingCache<String, JWK>>();
        this.openIdHelper = new OpenIdHelper(webClient, defaultJwkCacheDuration.toSeconds());
    }

    @Override
    public void optimize() {
    }

    private void validateIssuer(String issuer) throws IllegalArgumentException {
        if (this.discoveryDataCache.containsKey(issuer)) {
            return;
        }
        if (this.issuerAcceptabilityHandler.isAcceptable(issuer)) {
            return;
        }
        logger.warn("Issuer ({}) not considered acceptable by {}", (Object)issuer, (Object)this.issuerAcceptabilityHandler);
        throw new IllegalArgumentException("Parse of signed JWT failed");
    }

    @Override
    public Future<DiscoveryData> performOpenIdDiscovery(String issuer) {
        try {
            this.validateIssuer(issuer);
        }
        catch (Throwable ex) {
            return Future.failedFuture((Throwable)ex);
        }
        String discoveryUrl = issuer + (issuer.endsWith("/") ? "" : "/") + ".well-known/openid-configuration";
        return this.discoveryDataCache.get(issuer, () -> this.openIdHelper.get(discoveryUrl).map(tjo -> this.discoveryDataCache.entry(new DiscoveryData((JsonObject)tjo.getValue()), tjo.getExpiryMs())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<JWK> findJwk(DiscoveryData discoveryData, String kid) {
        AsyncLoadingCache<String, JWK> finalJwkCache;
        String jwksUri = discoveryData.getJwksUri();
        if (Strings.isNullOrEmpty((String)jwksUri)) {
            return Future.failedFuture((String)"Discovery data does not contain jwks_uri");
        }
        Map<String, AsyncLoadingCache<String, JWK>> map = this.kidCache;
        synchronized (map) {
            AsyncLoadingCache<String, Object> jwkCache = this.kidCache.get(jwksUri);
            if (jwkCache == null) {
                jwkCache = new AsyncLoadingCache();
                this.kidCache.put(jwksUri, jwkCache);
            }
            finalJwkCache = jwkCache;
        }
        return finalJwkCache.get(kid, () -> this.openIdHelper.get(discoveryData.getJwksUri()).compose(tjo -> JWKSOpenIdDiscoveryHandlerImpl.processJwkSet(discoveryData.getJwksUri(), finalJwkCache, tjo, kid)));
    }

    @Override
    public Future<JWK> findJwk(String issuer, String kid) {
        return this.performOpenIdDiscovery(issuer).compose(dd -> this.findJwk((DiscoveryData)dd, kid));
    }

    static Future<AsyncLoadingCache.TimedObject<JWK>> processJwkSet(String sourceUrl, AsyncLoadingCache<String, JWK> jwkCache, AsyncLoadingCache.TimedObject<JsonObject> data, String kid) {
        JsonObject foundKey;
        JWK result;
        long expiry;
        block10: {
            expiry = data.getExpiryMs();
            result = null;
            foundKey = null;
            try {
                Object keysObject = data.getValue().getValue("keys");
                if (keysObject instanceof JsonArray) {
                    JsonArray ja = (JsonArray)keysObject;
                    for (Object keyData : ja) {
                        try {
                            if (!(keyData instanceof JsonObject)) continue;
                            JsonObject jo = (JsonObject)keyData;
                            String keyId = jo.getString("kid");
                            if (kid.equals(keyId)) {
                                result = new JWK(jo);
                                foundKey = jo;
                                continue;
                            }
                            JWK other = new JWK(jo);
                            jwkCache.put(keyId, jwkCache.entry(other, expiry));
                        }
                        catch (Throwable ex) {
                            logger.warn("Failed to parse {} from {} as a JWK: ", new Object[]{keyData, sourceUrl, ex});
                        }
                    }
                    break block10;
                }
                logger.error("Failed to get key {} from JWKS from {}", (Object)kid, (Object)data.getValue());
                return Future.failedFuture((Throwable)new IllegalArgumentException("Parse of signed JWT failed", new IllegalArgumentException("Failed to get public key for " + kid)));
            }
            catch (Throwable ex) {
                logger.error("Failed to get public key for {} from {}", (Object)kid, (Object)data.getValue());
                return Future.failedFuture((Throwable)new IllegalArgumentException("Parse of signed JWT failed", new IllegalArgumentException("Failed to get public key for " + kid)));
            }
        }
        if (result == null) {
            logger.error("Failed to find key {} from JWKS from {}", (Object)kid, (Object)data.getValue());
            return Future.failedFuture((Throwable)new IllegalArgumentException("Parse of signed JWT failed", new IllegalArgumentException("Failed to find key " + kid)));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Got new {} public key with id {}: {}", new Object[]{result.getAlgorithm(), kid, foundKey});
        } else {
            logger.info("Got new public key with id {}", (Object)kid);
        }
        return Future.succeededFuture(jwkCache.entry(result, expiry));
    }
}

