/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.jwtvalidatorvertx.impl;

import com.google.common.collect.ImmutableList;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.impl.jose.JWK;
import io.vertx.ext.web.client.WebClient;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.spudsoft.jwtvalidatorvertx.JsonWebKeySetKnownJwksHandler;
import uk.co.spudsoft.jwtvalidatorvertx.impl.AsyncLoadingCache;
import uk.co.spudsoft.jwtvalidatorvertx.impl.JWKSOpenIdDiscoveryHandlerImpl;
import uk.co.spudsoft.jwtvalidatorvertx.impl.OpenIdHelper;

public class JWKSStaticSetHandlerImpl
implements JsonWebKeySetKnownJwksHandler {
    private static final Logger logger = LoggerFactory.getLogger(JWKSOpenIdDiscoveryHandlerImpl.class);
    private final List<String> jwksUrls;
    private final Map<String, AsyncLoadingCache.TimedObject<JWK>> keys = new HashMap<String, AsyncLoadingCache.TimedObject<JWK>>();
    private final AtomicReference<Future<Void>> refreshFuture = new AtomicReference<Object>(null);
    private final OpenIdHelper openIdHelper;

    public JWKSStaticSetHandlerImpl(WebClient webClient, Collection<String> jwksUrls, Duration defaultJwkCacheDuration) {
        this.jwksUrls = ImmutableList.copyOf(jwksUrls);
        this.openIdHelper = new OpenIdHelper(webClient, defaultJwkCacheDuration.toSeconds());
    }

    @Override
    public void optimize() {
        this.findJwk(null, "");
    }

    private JWK findJwk(String kid) {
        AsyncLoadingCache.TimedObject<JWK> jwk = this.keys.get(kid);
        long now = System.currentTimeMillis();
        if (null != jwk) {
            if (jwk.expiredBefore(now)) {
                this.keys.remove(kid);
            } else {
                return jwk.getValue();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<JWK> findJwk(String issuer, String kid) {
        Map<String, AsyncLoadingCache.TimedObject<JWK>> map = this.keys;
        synchronized (map) {
            JWK jwk = this.findJwk(kid);
            if (jwk != null) {
                return Future.succeededFuture((Object)jwk);
            }
            Promise refreshPromise = Promise.promise();
            Future newRefreshFuture = refreshPromise.future();
            Future result = this.refreshFuture.compareAndExchange(null, (Future<Void>)newRefreshFuture);
            if (result == null) {
                result = this.updateCache().compose(newkeys -> {
                    Map<String, AsyncLoadingCache.TimedObject<JWK>> map = this.keys;
                    synchronized (map) {
                        this.keys.putAll((Map<String, AsyncLoadingCache.TimedObject<JWK>>)newkeys);
                    }
                    refreshPromise.complete();
                    this.refreshFuture.set(null);
                    return Future.succeededFuture();
                });
            }
            return result.compose(v -> {
                Map<String, AsyncLoadingCache.TimedObject<JWK>> map = this.keys;
                synchronized (map) {
                    JWK newjwk = this.findJwk(kid);
                    if (newjwk != null) {
                        return Future.succeededFuture((Object)newjwk);
                    }
                    return Future.failedFuture((Throwable)new IllegalArgumentException("The key \"" + kid + "\" cannot be found."));
                }
            });
        }
    }

    private Future<Map<String, AsyncLoadingCache.TimedObject<JWK>>> updateCache() {
        if (this.jwksUrls.isEmpty()) {
            logger.error("Unable to validate any JWKs because no jwksUrls have been configured");
            IllegalStateException ex = new IllegalStateException("Unable to validate any JWKs because no jwksUrls have been configured");
            return Future.failedFuture((Throwable)ex);
        }
        HashMap result = new HashMap();
        ArrayList<Future> futures = new ArrayList<Future>();
        for (String jwksUrl : this.jwksUrls) {
            futures.add(this.openIdHelper.get(jwksUrl).compose(tjo -> this.addKeysToCache(jwksUrl, (AsyncLoadingCache.TimedObject<JsonObject>)tjo, result)));
        }
        return Future.all(futures).compose(cf -> Future.succeededFuture((Object)result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Void> addKeysToCache(String url, AsyncLoadingCache.TimedObject<JsonObject> data, Map<String, AsyncLoadingCache.TimedObject<JWK>> result) {
        block9: {
            try {
                Object keysObject = data.getValue().getValue("keys");
                if (keysObject instanceof JsonArray) {
                    JsonArray ja = (JsonArray)keysObject;
                    for (Object keyData : ja) {
                        try {
                            if (!(keyData instanceof JsonObject)) continue;
                            JsonObject jo = (JsonObject)keyData;
                            String keyId = jo.getString("kid");
                            JWK jwk = new JWK(jo);
                            Map<String, AsyncLoadingCache.TimedObject<JWK>> map = result;
                            synchronized (map) {
                                result.put(keyId, new AsyncLoadingCache.TimedObject<JWK>(jwk, data.getExpiryMs()));
                            }
                        }
                        catch (Throwable ex) {
                            logger.warn("Failed to parse {} from {} as a JWK: ", new Object[]{keyData, url, ex});
                        }
                    }
                    break block9;
                }
                logger.error("Failed to get JWKS from {} (returned value does not contain a keys array: {}))", (Object)url, (Object)data.getValue());
                return Future.failedFuture((Throwable)new IllegalArgumentException("Failed to parse JWKS from " + url));
            }
            catch (Throwable ex) {
                logger.error("Failed to get process JWKS from {} ({}): ", new Object[]{url, data.getValue(), ex});
                return Future.failedFuture((Throwable)new IllegalArgumentException("Failed to process JWKS from " + url));
            }
        }
        return Future.succeededFuture();
    }
}

