/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.jwtvalidatorvertx.impl;

import io.vertx.core.Future;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.spudsoft.jwtvalidatorvertx.impl.AsyncLoadingCache;

public class OpenIdHelper {
    private static final Logger logger = LoggerFactory.getLogger(OpenIdHelper.class);
    private final WebClient webClient;
    private final long defaultCacheDurationS;

    public OpenIdHelper(WebClient webClient, long defaultCacheDurationS) {
        this.webClient = webClient;
        this.defaultCacheDurationS = defaultCacheDurationS;
    }

    private static boolean succeeded(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    private long calculateExpiry(long requestTimeMsSinceEpoch, HttpResponse<?> response) {
        long maxAgeSecondsSinceEpoch = Long.MAX_VALUE;
        for (String header : response.headers().getAll(HttpHeaders.CACHE_CONTROL)) {
            for (String headerDirective : header.split(",")) {
                String[] directiveParts = headerDirective.split("=", 2);
                directiveParts[0] = directiveParts[0].trim();
                if (!"max-age".equals(directiveParts[0])) continue;
                try {
                    long value = Long.parseLong(directiveParts[1].replaceAll("\"", "").trim().toLowerCase());
                    if (value <= 0L || value >= maxAgeSecondsSinceEpoch) continue;
                    maxAgeSecondsSinceEpoch = value;
                }
                catch (NumberFormatException e) {
                    logger.warn("Invalid max-age cache-control directive ({}): ", (Object)directiveParts[1], (Object)e);
                }
            }
        }
        if (maxAgeSecondsSinceEpoch == Long.MAX_VALUE) {
            maxAgeSecondsSinceEpoch = this.defaultCacheDurationS;
        }
        return requestTimeMsSinceEpoch + maxAgeSecondsSinceEpoch * 1000L;
    }

    public Future<AsyncLoadingCache.TimedObject<JsonObject>> get(String url) {
        long requestTime = System.currentTimeMillis();
        try {
            return this.webClient.getAbs(url).send().map(response -> {
                if (OpenIdHelper.succeeded(response.statusCode())) {
                    String body = response.bodyAsString();
                    return new AsyncLoadingCache.TimedObject<JsonObject>(new JsonObject(body), this.calculateExpiry(requestTime, (HttpResponse<?>)response));
                }
                logger.debug("Request to {} returned {}: {}", new Object[]{url, response.statusCode(), response.bodyAsString()});
                throw new IllegalStateException("Request to " + url + " returned " + response.statusCode());
            });
        }
        catch (Exception ex) {
            logger.error("The JWKS URI ({}) is not a valid URL: ", (Object)url, (Object)ex);
            return Future.failedFuture((Throwable)new IllegalArgumentException("Parse of signed JWT failed", ex));
        }
    }
}

