/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.jwtvalidatorvertx.impl;

import com.google.common.collect.ImmutableSet;
import io.vertx.core.json.JsonObject;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.spudsoft.jwtvalidatorvertx.JwkBuilder;

public class RSAJwkBuilder
extends JwkBuilder {
    private static final Logger logger = LoggerFactory.getLogger(RSAJwkBuilder.class);
    private static final String KTY = "RSA";
    private static final Set<String> VALID_ALGS = ImmutableSet.builder().add((Object)"RS256").add((Object)"RS384").add((Object)"RS512").build();

    @Override
    public boolean canHandleKey(PublicKey key) {
        return key instanceof RSAPublicKey;
    }

    @Override
    public JsonObject toJson(String kid, String algorithm, PublicKey publicKey) throws NoSuchAlgorithmException {
        RSAPublicKey key = (RSAPublicKey)publicKey;
        JsonObject json = new JsonObject();
        if (!VALID_ALGS.contains(algorithm)) {
            logger.warn("The algorithm {} is not in {}", (Object)algorithm, VALID_ALGS);
            throw new NoSuchAlgorithmException(algorithm);
        }
        json.put("alg", (Object)algorithm);
        json.put("kid", (Object)kid);
        json.put("kty", (Object)KTY);
        json.put("e", (Object)B64ENCODER.encodeToString(key.getPublicExponent().toByteArray()));
        json.put("n", (Object)B64ENCODER.encodeToString(key.getModulus().toByteArray()));
        return json;
    }
}

