/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.jwtvalidatorvertx.jdk;

import com.google.common.cache.Cache;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.ECGenParameterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.spudsoft.jwtvalidatorvertx.AlgorithmAndKeyPair;
import uk.co.spudsoft.jwtvalidatorvertx.JsonWebAlgorithm;
import uk.co.spudsoft.jwtvalidatorvertx.impl.AbstractTokenBuilder;

public class JdkTokenBuilder
extends AbstractTokenBuilder {
    private static final Logger logger = LoggerFactory.getLogger(JdkTokenBuilder.class);

    public JdkTokenBuilder(Cache<String, AlgorithmAndKeyPair> keyCache) {
        super(keyCache);
    }

    private KeyPair generateKey(String kid, JsonWebAlgorithm algorithm) throws Exception {
        if ("RSA".equals(algorithm.getFamilyName())) {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(algorithm.getMinKeyLength());
            return keyGen.genKeyPair();
        }
        if ("ECDSA".equals(algorithm.getFamilyName())) {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("EC");
            ECGenParameterSpec spec = new ECGenParameterSpec(algorithm.getSubName());
            keyGen.initialize(spec);
            return keyGen.genKeyPair();
        }
        if ("EdDSA".equals(algorithm.getFamilyName())) {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(algorithm.getJdkAlgName());
            return keyGen.genKeyPair();
        }
        if (algorithm == JsonWebAlgorithm.none) {
            return null;
        }
        throw new IllegalArgumentException("Test harness does not support keys for " + algorithm.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] generateSignature(String kid, JsonWebAlgorithm algorithm, String headerBase64, String claimsBase64) throws Exception {
        AlgorithmAndKeyPair akp;
        Cache cache = this.keyCache;
        synchronized (cache) {
            akp = (AlgorithmAndKeyPair)this.keyCache.get((Object)kid, () -> {
                KeyPair kp = this.generateKey(kid, algorithm);
                return new AlgorithmAndKeyPair(algorithm, kp);
            });
        }
        return JdkTokenBuilder.generateSignature(akp.getKeyPair().getPrivate(), algorithm, headerBase64 + "." + claimsBase64);
    }

    public static byte[] generateSignature(PrivateKey privateKey, JsonWebAlgorithm algorithm, String signingInput) throws Exception {
        Signature signer = Signature.getInstance(algorithm.getJdkAlgName());
        signer.initSign(privateKey);
        signer.update(signingInput.getBytes(StandardCharsets.UTF_8));
        return signer.sign();
    }
}

