/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.params4j;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Locale;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public class ConfigurationProperty {
    public final Class<?> type;
    public final String name;
    public final boolean canBeEnvVar;
    public final boolean undocumented;
    public final String comment;
    public final String defaultValue;

    public static Builder builder() {
        return new Builder();
    }

    private ConfigurationProperty(Class<?> type, String name, boolean canBeEnvVar, boolean undocumented, String comment, String defaultValue) {
        this.type = type;
        this.name = name;
        this.canBeEnvVar = canBeEnvVar;
        this.undocumented = undocumented;
        this.comment = comment;
        this.defaultValue = defaultValue;
    }

    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + Objects.hashCode(this.type);
        hash = 71 * hash + Objects.hashCode(this.name);
        hash = 71 * hash + (this.canBeEnvVar ? 1 : 0);
        hash = 71 * hash + (this.undocumented ? 1 : 0);
        hash = 71 * hash + Objects.hashCode(this.comment);
        hash = 71 * hash + Objects.hashCode(this.defaultValue);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationProperty other = (ConfigurationProperty)obj;
        if (this.canBeEnvVar != other.canBeEnvVar) {
            return false;
        }
        if (this.undocumented != other.undocumented) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.comment, other.comment)) {
            return false;
        }
        if (!Objects.equals(this.defaultValue, other.defaultValue)) {
            return false;
        }
        return Objects.equals(this.type, other.type);
    }

    public void appendUsage(StringBuilder builder, int maxNameLen, String lineTerminator) {
        maxNameLen += 6;
        builder.append("    ").append(this.name);
        if (this.undocumented) {
            builder.append(".<***>");
        }
        builder.append(" ".repeat(maxNameLen + 1 - this.name.length() - (this.undocumented ? 6 : 0))).append(this.comment).append('\n');
        String typeName = this.type.getSimpleName();
        builder.append("        ").append(typeName);
        if (this.undocumented) {
            builder.append(" ".repeat(typeName.length() + 10 > maxNameLen ? 1 : maxNameLen - typeName.length() - 3)).append("This parameter is undocumented, consult the source for ").append(this.type).append(" for details of the values for <***>");
        } else if (this.defaultValue != null) {
            builder.append(" ".repeat(typeName.length() + 10 > maxNameLen ? 1 : maxNameLen - typeName.length() - 3)).append("default: ").append(this.defaultValue);
        }
        builder.append(lineTerminator);
    }

    public void appendEnv(StringBuilder builder, int maxNameLen, String prefixStrip, String prefixAdd, String lineTerminator) {
        if (this.canBeEnvVar) {
            if (prefixStrip == null) {
                prefixStrip = "";
            }
            if (prefixAdd == null) {
                prefixAdd = "";
            }
            maxNameLen = maxNameLen - prefixStrip.length() + prefixAdd.length() + 7;
            Object envVarName = this.name;
            if (((String)envVarName).startsWith(prefixStrip)) {
                envVarName = ((String)envVarName).substring(prefixStrip.length());
            }
            envVarName = ((String)envVarName).replaceAll("\\.", "_");
            if (prefixAdd.length() > 0) {
                envVarName = prefixAdd + "_" + (String)envVarName;
            }
            envVarName = ((String)envVarName).toUpperCase(Locale.ROOT);
            builder.append("    ").append((String)envVarName);
            if (this.undocumented) {
                builder.append("_<***>");
            }
            builder.append(" ".repeat(maxNameLen + 1 - ((String)envVarName).length() - (this.undocumented ? 6 : 0))).append(this.comment).append('\n');
            String typeName = this.type.getSimpleName();
            builder.append("        ").append(typeName);
            if (this.undocumented) {
                builder.append(" ".repeat(typeName.length() + 10 > maxNameLen ? 1 : maxNameLen - typeName.length() - 3)).append("This parameter is undocumented, consult the source for ").append(this.type).append(" for details of the values for <***>");
            } else if (this.defaultValue != null) {
                builder.append(" ".repeat(typeName.length() + 10 > maxNameLen ? 1 : maxNameLen - typeName.length() - 3)).append("default: ").append(this.defaultValue);
            }
            builder.append(lineTerminator);
        }
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="")
    public static class Builder {
        private Class<?> type;
        private String name;
        private boolean canBeEnvVar;
        private boolean undocumented;
        private String comment;
        private String defaultValue;

        private Builder() {
        }

        public Builder type(Class<?> value) {
            this.type = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder canBeEnvVar(boolean value) {
            this.canBeEnvVar = value;
            return this;
        }

        public Builder undocumented(boolean value) {
            this.undocumented = value;
            return this;
        }

        public Builder comment(String value) {
            this.comment = value;
            return this;
        }

        public Builder defaultValue(String value) {
            this.defaultValue = value;
            return this;
        }

        public ConfigurationProperty build() {
            return new ConfigurationProperty(this.type, this.name, this.canBeEnvVar, this.undocumented, this.comment, this.defaultValue);
        }
    }
}

