/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.params4j;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import uk.co.spudsoft.params4j.Params4JSpi;

public enum FileType {
    Properties(Arrays.asList(".properties"), Params4JSpi::getPropsMapper),
    Yaml(Arrays.asList(".yaml", ".yml"), Params4JSpi::getYamlMapper),
    Json(Arrays.asList(".json"), Params4JSpi::getJsonMapper);

    private final List<String> extensions;
    private final Function<Params4JSpi, ObjectMapper> objectMapGetter;

    public List<String> getExtensions() {
        return this.extensions;
    }

    public ObjectMapper getObjectMapper(Params4JSpi spi) {
        return this.objectMapGetter.apply(spi);
    }

    private FileType(List<String> extensions, Function<Params4JSpi, ObjectMapper> objectMapGetter) {
        this.extensions = Collections.unmodifiableList(extensions);
        this.objectMapGetter = objectMapGetter;
    }

    public String toString() {
        return this.name() + " (" + String.valueOf(this.extensions) + ")";
    }
}

