/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.params4j.doclet;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Reporter;

public class AsciiDocLinkMaps {
    private static final String MODULE_PREFIX = "module:";
    private final List<String> configuredBaseUrls = new ArrayList<String>();
    private final Map<String, String> baseUrlFromPackage = new HashMap<String, String>();
    private boolean packageListsRead = false;

    public void addConfiguredBaseUrl(String baseUrl) {
        this.configuredBaseUrls.add(baseUrl);
    }

    public String getUrlForPackage(Reporter reporter, String packageName) {
        String baseUrl;
        if (!this.configuredBaseUrls.isEmpty() && !this.packageListsRead) {
            this.packageListsRead = true;
            for (String cofiguredBaseUrl : this.configuredBaseUrls) {
                AsciiDocLinkMaps.readPackageList(reporter, this.baseUrlFromPackage, cofiguredBaseUrl);
                AsciiDocLinkMaps.readElementList(reporter, this.baseUrlFromPackage, cofiguredBaseUrl);
            }
        }
        if ((baseUrl = this.baseUrlFromPackage.get(packageName)) == null) {
            return null;
        }
        return baseUrl + packageName.replace('.', '/') + "/";
    }

    public String getUrlForType(Reporter reporter, String packageName, String className) {
        String packageUrl = this.getUrlForPackage(reporter, packageName);
        if (packageUrl == null) {
            return null;
        }
        return packageUrl + className + ".html";
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Attempting to read package list from related documentation")
    static void readPackageList(Reporter reporter, Map<String, String> baseUrlFromPackage, String baseUrl) {
        String url = baseUrl.endsWith("/") ? baseUrl + "package-list" : baseUrl + "/package-list";
        try {
            URL link = new URI(url).toURL();
            URLConnection con = link.openConnection();
            con.setConnectTimeout(2000);
            con.setReadTimeout(2000);
            try (InputStream in = con.getInputStream();){
                AsciiDocLinkMaps.readPackageList(baseUrlFromPackage, in, baseUrl);
            }
        }
        catch (Throwable ex) {
            reporter.print(Diagnostic.Kind.NOTE, "Failed to download from URL " + url + " (" + ex.toString() + ")");
        }
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Attempting to read element list from related documentation")
    static void readElementList(Reporter reporter, Map<String, String> baseUrlFromPackage, String baseUrl) {
        String url = baseUrl.endsWith("/") ? baseUrl + "element-list" : baseUrl + "/element-list";
        try {
            URL link = new URI(url).toURL();
            URLConnection con = link.openConnection();
            con.setConnectTimeout(2000);
            con.setReadTimeout(2000);
            try (InputStream in = con.getInputStream();){
                AsciiDocLinkMaps.readPackageList(baseUrlFromPackage, in, baseUrl);
            }
        }
        catch (Throwable ex) {
            reporter.print(Diagnostic.Kind.NOTE, "Failed to download from URL " + url + " (" + ex.toString() + ")");
        }
    }

    static void readPackageList(Map<String, String> baseUrlFromPackage, InputStream input, String url) throws IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            String line;
            Object moduleUrl = url;
            if (!((String)url).endsWith("/")) {
                url = (String)url + "/";
            }
            while ((line = in.readLine()) != null) {
                if (line.isBlank()) continue;
                if (line.startsWith(MODULE_PREFIX)) {
                    String moduleName = line.substring(MODULE_PREFIX.length());
                    moduleUrl = (String)url + moduleName + "/";
                    continue;
                }
                String packageName = line;
                baseUrlFromPackage.put(packageName, (String)moduleUrl);
            }
        }
    }
}

