/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.params4j.impl;

import com.fasterxml.jackson.databind.ObjectReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.spudsoft.params4j.FileType;
import uk.co.spudsoft.params4j.ParameterGatherer;
import uk.co.spudsoft.params4j.Params4JSpi;

public class DirGatherer<P>
implements ParameterGatherer<P> {
    private static final Logger logger = LoggerFactory.getLogger(DirGatherer.class);
    private final File dir;
    private final List<FileType> fileTypes;

    public DirGatherer(File dir, FileType ... fileTypes) {
        this.dir = dir;
        this.fileTypes = Arrays.asList(fileTypes).stream().distinct().collect(Collectors.toList());
    }

    @Override
    public P gatherParameters(Params4JSpi spi, P base) throws IOException {
        HashSet<Object> usedFiles = new HashSet<Object>();
        if (this.dir.isDirectory()) {
            Object[] files = this.dir.listFiles();
            if (files != null) {
                Arrays.sort(files);
                for (FileType type : this.fileTypes) {
                    for (Object file : files) {
                        for (String extension : type.getExtensions()) {
                            if (!((File)file).exists() || !((File)file).getName().endsWith(extension)) continue;
                            logger.debug("Reading file {}", file);
                            usedFiles.add(file);
                            try {
                                ObjectReader reader = type.getObjectMapper(spi).readerForUpdating(base);
                                try (FileInputStream stream = new FileInputStream((File)file);){
                                    base = reader.readValue(stream);
                                }
                            }
                            catch (Throwable ex) {
                                logger.error("Failed to process file {}: ", file, (Object)ex);
                            }
                        }
                    }
                }
                for (Object file : files) {
                    if (usedFiles.contains(file)) continue;
                    logger.trace("Skipped the file {}, not of recognised type ({})", file, (Object)this.fileTypes);
                }
                spi.watch(this.dir.toPath());
            } else {
                logger.debug("No files in directory \"{}\"", (Object)this.dir);
            }
        } else {
            logger.debug("Config directory \"{}\" is not a directory", (Object)this.dir);
        }
        return base;
    }

    public String toString() {
        return "Dir (" + String.valueOf(this.dir) + ")";
    }
}

