/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.params4j.impl;

import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsSchema;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import uk.co.spudsoft.params4j.ParameterGatherer;
import uk.co.spudsoft.params4j.Params4JSpi;

public class EnvironmentVariablesGatherer<P>
implements ParameterGatherer<P> {
    private final Map<String, String> map = new HashMap<String, String>();
    private final String namePrefix;

    public EnvironmentVariablesGatherer(String namePrefix, boolean toLowerCase) {
        this(System.getenv(), namePrefix, toLowerCase);
    }

    public EnvironmentVariablesGatherer(Map<String, String> map, String namePrefix, boolean toLowerCase) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey().replaceAll("_", ".");
            if (toLowerCase) {
                key = key.toLowerCase();
            }
            this.map.put(key, entry.getValue());
        }
        this.namePrefix = namePrefix;
    }

    @Override
    public P gatherParameters(Params4JSpi spi, P base) throws IOException {
        ObjectReader reader = spi.getPropsMapper().readerForUpdating(base).with(new JavaPropsSchema().withPathSeparatorEscapeChar('\\'));
        byte[] props = spi.prepareProperties("Environment variables", this.map.entrySet(), Map.Entry::getKey, Map.Entry::getValue, this.namePrefix);
        if (props.length > 0) {
            return (P)reader.readValue(props);
        }
        return base;
    }

    public String toString() {
        return "Environment variables";
    }
}

