/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.params4j.impl;

import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.spudsoft.params4j.FileType;
import uk.co.spudsoft.params4j.ParameterGatherer;
import uk.co.spudsoft.params4j.Params4JSpi;

public class ResourceGatherer<P>
implements ParameterGatherer<P> {
    private static final Logger logger = LoggerFactory.getLogger(ResourceGatherer.class);
    private final String resource;
    private final FileType type;

    public ResourceGatherer(String resource, FileType fileType) {
        this.resource = resource;
        this.type = fileType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public P gatherParameters(Params4JSpi spi, P base) throws IOException {
        ObjectReader reader = this.type.getObjectMapper(spi).readerForUpdating(base);
        try (InputStream stream = this.getClass().getResourceAsStream(this.resource);){
            Object t = reader.readValue(stream);
            return (P)t;
        }
        catch (Throwable ex) {
            logger.debug("Unable to read resource: {}", (Object)this.resource);
            return base;
        }
    }

    public String toString() {
        return "Resource (" + this.resource + ")";
    }
}

