/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.params4j.impl;

import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.spudsoft.params4j.ParameterGatherer;
import uk.co.spudsoft.params4j.Params4JSpi;
import uk.co.spudsoft.params4j.impl.SecretsWalker;

public class SecretsGatherer<P>
implements ParameterGatherer<P> {
    private static final Logger logger = LoggerFactory.getLogger(SecretsGatherer.class);
    private final Path root;
    private final int fileSizeLimit;
    private final int fileCountLimit;
    private final int fileDepthLimit;
    private final Charset charset;

    public SecretsGatherer(Path root, int fileSizeLimit, int fileCountLimit, int fileDepthLimit, Charset charset) {
        this.root = root;
        this.fileSizeLimit = fileSizeLimit;
        this.fileCountLimit = fileCountLimit;
        this.fileDepthLimit = fileDepthLimit;
        this.charset = charset;
    }

    @Override
    public P gatherParameters(Params4JSpi spi, P base) throws IOException {
        SecretsWalker visitor = new SecretsWalker(this.root, spi.getJsonMapper(), this.fileSizeLimit, this.fileCountLimit, this.charset, dir -> {
            try {
                spi.watch((Path)dir);
            }
            catch (IOException ex) {
                logger.warn("Failed to establish watch on {}: ", dir, (Object)ex);
            }
        });
        Files.walkFileTree(this.root, EnumSet.of(FileVisitOption.FOLLOW_LINKS), this.fileDepthLimit, visitor);
        ObjectNode node = visitor.getObjectNode();
        if (!node.isEmpty()) {
            ObjectReader reader = spi.getJsonMapper().readerForUpdating(base);
            base = reader.readValue(node);
        }
        return base;
    }

    public String toString() {
        return "Secrets (" + String.valueOf(this.root) + ")";
    }
}

