/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.params4j.impl;

import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsSchema;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import uk.co.spudsoft.params4j.ParameterGatherer;
import uk.co.spudsoft.params4j.Params4JSpi;

public class SystemPropertiesGatherer<P>
implements ParameterGatherer<P> {
    private final Properties sysProps;
    private final String propertyPrefix;

    public SystemPropertiesGatherer(String namePrefix) {
        this(System.getProperties(), namePrefix);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Externable objects are mutable")
    public SystemPropertiesGatherer(Properties props, String namePrefix) {
        this.sysProps = props;
        this.propertyPrefix = namePrefix;
    }

    @Override
    public P gatherParameters(Params4JSpi spi, P base) throws IOException {
        ObjectReader reader = spi.getPropsMapper().readerForUpdating(base).with(new JavaPropsSchema().withPathSeparatorEscapeChar('\\'));
        byte[] props = spi.prepareProperties("System properties", this.sysProps.entrySet(), Map.Entry::getKey, Map.Entry::getValue, this.propertyPrefix);
        if (props.length > 0) {
            return (P)reader.readValue(props);
        }
        return base;
    }

    public String toString() {
        return "System properties";
    }
}

