/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.params4j.doclet;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.AuthorTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.EntityTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.SeeTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.source.util.TreePath;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;
import uk.co.spudsoft.params4j.doclet.AsciiDocOptions;
import uk.co.spudsoft.params4j.doclet.HtmlEntities;
import uk.co.spudsoft.params4j.doclet.TypeWriter;

public class AsciiDocDocTreeWalker
extends DocTreePathScanner<Void, Void> {
    private final DocletEnvironment environment;
    private final Writer writer;
    private final Reporter reporter;
    private final TreePath path;
    private DocCommentTree dc;
    private final TypeWriter typeWriter;
    private final Queue<Boolean> listOrderedStack = new ArrayDeque<Boolean>();
    private boolean inPara;
    private boolean inSource;
    private static final Pattern NUMERIC_ENTITY = Pattern.compile("&#([0-9]{1,6});");
    private static final Pattern TEXT_ENTITY = Pattern.compile("&([a-zA-Z]{1,6});");

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="The writer should be considered dedicated to this purpose whilst this walker is in operation.")
    public AsciiDocDocTreeWalker(DocletEnvironment environment, AsciiDocOptions options, Writer writer, Reporter reporter, TreePath path) {
        this.environment = environment;
        this.writer = writer;
        this.reporter = reporter;
        this.path = path;
        this.typeWriter = new TypeWriter(writer, reporter, options.getIncludeClasses(), options.getLinkMaps());
    }

    public void scan() {
        this.dc = this.environment.getDocTrees().getDocCommentTree(this.path);
        this.scan(new DocTreePath(this.path, this.dc), null);
    }

    @Override
    public Void visitEndElement(EndElementTree node, Void p) {
        String name = node.getName().toString();
        if (name.equalsIgnoreCase("ul")) {
            this.listOrderedStack.poll();
            this.write("\n");
        } else if (name.equalsIgnoreCase("ol")) {
            this.listOrderedStack.poll();
            this.write("\n");
        } else if (name.equalsIgnoreCase("a")) {
            this.write("] ");
        } else if (name.equalsIgnoreCase("pre") || name.equalsIgnoreCase("code")) {
            if (this.inSource) {
                this.inSource = false;
                this.write("\n----\n");
            }
        } else {
            this.write(node.toString());
            this.write(" ");
        }
        return (Void)super.visitEndElement(node, p);
    }

    @Override
    public Void visitLink(LinkTree node, Void p) {
        this.scan(node.getReference(), null);
        ReferenceTree refTree = node.getReference();
        this.typeWriter.writeReferenceTree(this.environment, this.getCurrentPath(), refTree);
        return (Void)super.visitLink(node, p);
    }

    @Override
    public Void visitStartElement(StartElementTree node, Void p) {
        String name = node.getName().toString();
        if (name.equalsIgnoreCase("ul")) {
            this.listOrderedStack.add(Boolean.FALSE);
        } else if (name.equalsIgnoreCase("ol")) {
            this.listOrderedStack.add(Boolean.TRUE);
        } else if (name.equalsIgnoreCase("li")) {
            if (!this.listOrderedStack.isEmpty() && this.listOrderedStack.peek().booleanValue()) {
                this.write(". ");
            } else {
                this.write("* ");
            }
        } else if (name.equalsIgnoreCase("p")) {
            this.write("\n\n");
        } else {
            if (name.equalsIgnoreCase("a")) {
                this.write("link:");
                String attributeValue = this.findAttribute(node, "href");
                if (attributeValue != null) {
                    this.write(attributeValue);
                }
                this.write("[");
                return null;
            }
            if (name.equalsIgnoreCase("pre") || name.equalsIgnoreCase("code")) {
                if (!this.inSource) {
                    this.inSource = true;
                    this.write("\n[source");
                    String attributeValue = this.findAttribute(node, "data-lang");
                    if (attributeValue != null) {
                        this.write(",");
                        this.write(attributeValue);
                    }
                    this.write("]\n");
                    this.write("----\n");
                    return null;
                }
            } else {
                this.reporter.print(Diagnostic.Kind.WARNING, new DocTreePath(this.path, this.dc), "Unrecognised HTML tag (" + name + ").");
                this.write(node.toString());
            }
        }
        return (Void)super.visitStartElement(node, p);
    }

    String findAttribute(StartElementTree node, String requiredAttribute) {
        for (DocTree docTree : node.getAttributes()) {
            AttributeTree attributeTree;
            if (!(docTree instanceof AttributeTree) || !(attributeTree = (AttributeTree)docTree).getName().toString().equalsIgnoreCase(requiredAttribute)) continue;
            return attributeTree.getValue().toString();
        }
        return null;
    }

    @Override
    public Void visitText(TextTree node, Void p) {
        String text = node.getBody();
        if (!this.inPara) {
            text = text.stripLeading();
        }
        this.write(text);
        return (Void)super.visitText(node, p);
    }

    @Override
    public Void visitLiteral(LiteralTree node, Void p) {
        this.write("`+");
        super.visitLiteral(node, p);
        this.write("+`");
        return null;
    }

    @Override
    public Void visitEntity(EntityTree node, Void p) {
        String entityRef = node.toString();
        try {
            String ref;
            String character;
            Matcher matcher = NUMERIC_ENTITY.matcher(entityRef);
            if (matcher.matches()) {
                String ref2 = matcher.group(1);
                int code = Integer.parseInt(ref2);
                this.write(Character.toString(code));
                return null;
            }
            matcher = TEXT_ENTITY.matcher(entityRef);
            if (matcher.matches() && (character = HtmlEntities.lookupEntity(ref = matcher.group(1).toLowerCase())) != null) {
                this.write(character);
                return null;
            }
        }
        catch (Throwable ex) {
            this.reporter.print(Diagnostic.Kind.ERROR, new DocTreePath(this.path, this.dc), "Failed to process entity: " + node.toString());
        }
        this.write(node.toString());
        return null;
    }

    @Override
    public Void visitSee(SeeTree node, Void p) {
        this.write("\n\nSee: ");
        return (Void)super.visitSee(node, p);
    }

    @Override
    public Void visitParam(ParamTree node, Void p) {
        return null;
    }

    @Override
    public Void visitReturn(ReturnTree node, Void p) {
        return null;
    }

    @Override
    public Void visitAuthor(AuthorTree node, Void p) {
        return null;
    }

    private void write(String s) {
        if (s != null) {
            this.inPara = !s.endsWith("\n");
            try {
                this.writer.write(s);
            }
            catch (IOException ex) {
                this.reporter.print(Diagnostic.Kind.ERROR, new DocTreePath(this.path, this.dc), "Failed to write: " + ex.getMessage());
            }
        }
    }
}

