/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.params4j.doclet;

import com.sun.source.doctree.DocCommentTree;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor14;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;
import uk.co.spudsoft.params4j.doclet.AsciiDocDocTreeWalker;
import uk.co.spudsoft.params4j.doclet.AsciiDocOptions;
import uk.co.spudsoft.params4j.doclet.TypeWriter;
import uk.co.spudsoft.params4j.impl.JavadocCapturer;

public class AsciiDocElementVisitor
implements ElementVisitor<Void, Boolean> {
    private final DocletEnvironment environment;
    private final AsciiDocOptions options;
    private final Reporter reporter;
    private Writer writer;
    private TypeWriter typeWriter;
    private final Set<String> fields = new HashSet<String>();
    private final Map<String, String> capturedDocs = new HashMap<String, String>();

    public AsciiDocElementVisitor(DocletEnvironment environment, AsciiDocOptions options, Reporter reporter) {
        this.environment = environment;
        this.options = options;
        this.reporter = reporter;
    }

    @Override
    public Void visit(Element e, Boolean p) {
        return null;
    }

    @Override
    public Void visitPackage(PackageElement e, Boolean p) {
        return this.visitStandard(e, p);
    }

    private boolean include(TypeElement e) {
        if (this.options.getIncludeClasses() == null || this.options.getIncludeClasses().isEmpty()) {
            return true;
        }
        return this.options.getIncludeClasses().contains(e.getQualifiedName().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="The point of this class is to write to that file, ensure it is correct")
    public Void visitType(TypeElement e, Boolean p) {
        this.reporter.print(Diagnostic.Kind.NOTE, "Visiting Type " + String.valueOf(e.getQualifiedName()));
        if (this.include(e)) {
            File dir = new File(this.options.getDestDirName());
            if (!dir.exists() && !dir.mkdirs()) {
                this.reporter.print(Diagnostic.Kind.ERROR, "Failed to create directory " + dir.getAbsolutePath());
                return null;
            }
            this.fields.clear();
            File output = new File(dir, String.valueOf(e.getQualifiedName()) + ".adoc");
            this.reporter.print(Diagnostic.Kind.NOTE, "Writing file " + output.getAbsolutePath());
            try (FileWriter newWriter = new FileWriter(output, StandardCharsets.UTF_8);){
                this.writer = newWriter;
                this.typeWriter = new TypeWriter(this.writer, this.reporter, this.options.getIncludeClasses(), this.options.getLinkMaps());
                try {
                    this.writer.write("= " + String.valueOf(e.getSimpleName()));
                    this.writer.write("\n\n");
                    AsciiDocDocTreeWalker docTreeWalker = new AsciiDocDocTreeWalker(this.environment, this.options, this.writer, this.reporter, this.environment.getDocTrees().getPath(e));
                    docTreeWalker.scan();
                    this.writer.write("\n");
                    this.writer.write("\n");
                    this.writer.write("[cols=\"1,1a,4a\",stripes=even]\n");
                    this.writer.write("|===\n");
                    this.writer.write("| Name\n");
                    this.writer.write("| Type\n");
                    this.writer.write("| Details\n");
                    this.writer.write("\n\n");
                    this.documentFields(e);
                    TypeMirror superMirror = e.getSuperclass();
                    while (superMirror != null) {
                        Element superElement = this.environment.getTypeUtils().asElement(superMirror);
                        if (superElement instanceof TypeElement) {
                            TypeElement superTypeElement = (TypeElement)superElement;
                            this.documentFields(superTypeElement);
                            superMirror = superTypeElement.getSuperclass();
                            continue;
                        }
                        superMirror = null;
                    }
                    this.writer.write("|===\n");
                }
                catch (IOException ex) {
                    this.reporter.print(Diagnostic.Kind.ERROR, "Failed to write to file: " + ex.getMessage());
                }
            }
            catch (IOException ex) {
                this.reporter.print(Diagnostic.Kind.ERROR, "Failed to open file " + output.getAbsolutePath());
                Void void_ = null;
                return void_;
            }
            finally {
                this.writer = null;
            }
        }
        return null;
    }

    private void documentFields(TypeElement type) {
        type.getEnclosedElements().forEach(enclosed -> {
            if (enclosed.getKind() == ElementKind.FIELD) {
                enclosed.accept(this, Boolean.FALSE);
            }
        });
        type.getEnclosedElements().forEach(enclosed -> {
            if (enclosed.getKind() == ElementKind.METHOD) {
                enclosed.accept(this, Boolean.TRUE);
            }
        });
        type.getEnclosedElements().forEach(enclosed -> {
            if (enclosed.getKind() == ElementKind.METHOD) {
                enclosed.accept(this, Boolean.FALSE);
            }
        });
        type.getEnclosedElements().forEach(enclosed -> {
            if (enclosed.getKind() == ElementKind.FIELD) {
                enclosed.accept(this, Boolean.TRUE);
            }
        });
    }

    @Override
    public Void visitVariable(VariableElement e, Boolean p) {
        if (p == null || p.booleanValue()) {
            return this.visitVariableAndOutputNonPrivate(e);
        }
        return this.visitVariableAndCapturePrivate(e);
    }

    @Override
    public Void visitExecutable(ExecutableElement e, Boolean p) {
        if (p == null || p.booleanValue()) {
            return this.visitExecutableAndOutputSetters(e);
        }
        return this.visitExecutableAndOutputGetters(e);
    }

    public Void visitVariableAndCapturePrivate(VariableElement e) {
        try {
            String doc;
            String fieldName = e.getSimpleName().toString();
            StringWriter stringWriter = new StringWriter();
            AsciiDocDocTreeWalker docTreeWalker = new AsciiDocDocTreeWalker(this.environment, this.options, stringWriter, this.reporter, this.environment.getDocTrees().getPath(e));
            DocCommentTree docCommentTree = this.environment.getDocTrees().getDocCommentTree(e);
            if (docCommentTree != null) {
                docTreeWalker.scan();
            }
            if ((doc = ((Object)stringWriter).toString()) != null && !doc.isBlank()) {
                this.capturedDocs.put(fieldName, doc);
            }
        }
        catch (Throwable ex) {
            this.reporter.print(Diagnostic.Kind.ERROR, "Failed to process field: " + ex.getMessage());
        }
        return null;
    }

    public Void visitVariableAndOutputNonPrivate(VariableElement e) {
        try {
            String fieldName = e.getSimpleName().toString();
            if (!this.fields.contains(fieldName) && !e.getModifiers().contains((Object)Modifier.PRIVATE)) {
                TypeElement typeElement;
                this.fields.add(fieldName);
                this.writer.write("\n| [[");
                this.writer.write(fieldName);
                this.writer.write("]]");
                this.writer.write(fieldName);
                this.writer.write("\n");
                this.writer.write("| ");
                VariableElement variableElement = e;
                DeclaredType declaredType = this.getDeclaredType(variableElement);
                Element declaredTypeElement = declaredType == null ? null : declaredType.asElement();
                TypeElement typeElement2 = typeElement = declaredTypeElement instanceof TypeElement ? (TypeElement)declaredTypeElement : null;
                if (typeElement == null) {
                    this.writer.write(variableElement.asType().toString());
                } else {
                    this.typeWriter.writeDeclaredType(declaredType);
                }
                this.writer.write("\n");
                this.writer.write("| ");
                AsciiDocDocTreeWalker docTreeWalker = new AsciiDocDocTreeWalker(this.environment, this.options, this.writer, this.reporter, this.environment.getDocTrees().getPath(e));
                DocCommentTree docCommentTree = this.environment.getDocTrees().getDocCommentTree(e);
                if (docCommentTree == null) {
                    this.reporter.print(Diagnostic.Kind.WARNING, "No doc comment for " + String.valueOf(e.getSimpleName()));
                } else {
                    docTreeWalker.scan();
                }
                this.writer.write("\n\n");
            }
        }
        catch (IOException ex) {
            this.reporter.print(Diagnostic.Kind.ERROR, "Failed to write to file: " + ex.getMessage());
        }
        return null;
    }

    private DeclaredType getDeclaredType(VariableElement variableElement) {
        DeclaredType declaredType = variableElement.asType().accept(new SimpleTypeVisitor14<DeclaredType, Void>(){

            @Override
            public DeclaredType visitDeclared(DeclaredType t, Void p) {
                return t;
            }
        }, null);
        return declaredType;
    }

    public Void visitExecutableAndOutputSetters(ExecutableElement e) {
        if (!e.getModifiers().contains((Object)Modifier.PRIVATE) && e.getSimpleName().toString().startsWith("set") && e.getParameters().size() == 1) {
            try {
                String fieldName = JavadocCapturer.setterNameToVariableName(e.getSimpleName().toString());
                if (!this.fields.contains(fieldName)) {
                    TypeElement typeElement;
                    this.fields.add(fieldName);
                    this.writer.write("\n| [[");
                    this.writer.write(fieldName);
                    this.writer.write("]]");
                    this.writer.write(fieldName);
                    this.writer.write("\n");
                    this.writer.write("| ");
                    VariableElement variableElement = e.getParameters().get(0);
                    DeclaredType declaredType = this.getDeclaredType(variableElement);
                    Element declaredTypeElement = declaredType == null ? null : declaredType.asElement();
                    TypeElement typeElement2 = typeElement = declaredTypeElement instanceof TypeElement ? (TypeElement)declaredTypeElement : null;
                    if (typeElement == null) {
                        this.writer.write(variableElement.asType().toString());
                    } else {
                        this.typeWriter.writeDeclaredType(declaredType);
                    }
                    this.writer.write("\n");
                    this.writer.write("| ");
                    StringWriter stringWriter = new StringWriter();
                    AsciiDocDocTreeWalker docTreeWalker = new AsciiDocDocTreeWalker(this.environment, this.options, stringWriter, this.reporter, this.environment.getDocTrees().getPath(e));
                    DocCommentTree docCommentTree = this.environment.getDocTrees().getDocCommentTree(e);
                    if (docCommentTree == null) {
                        this.reporter.print(Diagnostic.Kind.WARNING, "No doc comment for " + String.valueOf(e.getSimpleName()));
                    } else {
                        docTreeWalker.scan();
                    }
                    String doc = ((Object)stringWriter).toString();
                    if (doc == null || doc.isBlank()) {
                        doc = this.capturedDocs.get(fieldName);
                    }
                    if (doc != null) {
                        this.writer.write(doc);
                    }
                    this.writer.write("\n");
                }
            }
            catch (IOException ex) {
                this.reporter.print(Diagnostic.Kind.ERROR, "Failed to write to file: " + ex.getMessage());
            }
            e.getEnclosedElements().forEach(enclosed -> enclosed.accept(this, null));
        }
        return null;
    }

    public Void visitExecutableAndOutputGetters(ExecutableElement e) {
        if (!e.getModifiers().contains((Object)Modifier.PRIVATE) && (e.getSimpleName().toString().startsWith("get") || e.getSimpleName().toString().startsWith("is")) && e.getParameters().isEmpty() && !e.getEnclosingElement().getSimpleName().toString().equals("Object")) {
            try {
                String fieldName = JavadocCapturer.getterNameToVariableName(e.getSimpleName().toString());
                if (!this.fields.contains(fieldName)) {
                    TypeElement typeElement;
                    this.fields.add(fieldName);
                    this.writer.write("\n| [[");
                    this.writer.write(fieldName);
                    this.writer.write("]]");
                    this.writer.write(fieldName);
                    this.writer.write("\n");
                    this.writer.write("| ");
                    TypeMirror returnType = e.getReturnType();
                    DeclaredType declaredType = returnType.accept(new SimpleTypeVisitor14<DeclaredType, Void>(){

                        @Override
                        public DeclaredType visitDeclared(DeclaredType t, Void p) {
                            return t;
                        }
                    }, null);
                    Element declaredTypeElement = declaredType == null ? null : declaredType.asElement();
                    TypeElement typeElement2 = typeElement = declaredTypeElement instanceof TypeElement ? (TypeElement)declaredTypeElement : null;
                    if (typeElement == null) {
                        this.writer.write(returnType.toString());
                    } else {
                        this.typeWriter.writeDeclaredType(declaredType);
                    }
                    this.writer.write("\n");
                    this.writer.write("| ");
                    StringWriter stringWriter = new StringWriter();
                    AsciiDocDocTreeWalker docTreeWalker = new AsciiDocDocTreeWalker(this.environment, this.options, stringWriter, this.reporter, this.environment.getDocTrees().getPath(e));
                    DocCommentTree docCommentTree = this.environment.getDocTrees().getDocCommentTree(e);
                    if (docCommentTree == null) {
                        this.reporter.print(Diagnostic.Kind.WARNING, "No doc comment for " + String.valueOf(e.getSimpleName()));
                    } else {
                        docTreeWalker.scan();
                    }
                    String doc = ((Object)stringWriter).toString();
                    if (doc == null || doc.isBlank()) {
                        doc = this.capturedDocs.get(fieldName);
                    }
                    if (doc != null) {
                        this.writer.write(doc);
                    }
                    this.writer.write("\n");
                }
            }
            catch (IOException ex) {
                this.reporter.print(Diagnostic.Kind.ERROR, "Failed to write to file: " + ex.getMessage());
            }
            e.getEnclosedElements().forEach(enclosed -> enclosed.accept(this, null));
        }
        return null;
    }

    @Override
    public Void visitTypeParameter(TypeParameterElement e, Boolean p) {
        return this.visitStandard(e, p);
    }

    @Override
    public Void visitUnknown(Element e, Boolean p) {
        return this.visitStandard(e, p);
    }

    private <T extends Element> Void visitStandard(T e, Boolean p) {
        e.getEnclosedElements().forEach(enclosed -> enclosed.accept(this, null));
        return null;
    }
}

