/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.params4j.doclet;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jdk.javadoc.doclet.Doclet;
import uk.co.spudsoft.params4j.doclet.AbstractAsciiDocOption;
import uk.co.spudsoft.params4j.doclet.AsciiDocLinkMaps;

public class AsciiDocOptions {
    private final List<Doclet.Option> options = this.buildOptions();
    private String destDirName;
    private final Set<String> includeClasses = new HashSet<String>();
    private final AsciiDocLinkMaps linkMaps = new AsciiDocLinkMaps();

    private List<Doclet.Option> buildOptions() {
        ArrayList<Doclet.Option> result = new ArrayList<Doclet.Option>();
        result.add(new AbstractAsciiDocOption(1, "Destination directory for output files", "-d", "directory"){

            @Override
            public boolean process(String option, List<String> arguments) {
                AsciiDocOptions.this.destDirName = arguments.get(0);
                return true;
            }
        });
        result.add(new AbstractAsciiDocOption(1, "If set, only the listed classes will be processed", "--include-classes", "include-classes"){

            @Override
            public boolean process(String option, List<String> arguments) {
                for (String arg : arguments) {
                    String[] parts;
                    for (String part : parts = arg.split(",")) {
                        AsciiDocOptions.this.includeClasses.add(part.trim());
                    }
                }
                return true;
            }
        });
        result.add(new AbstractAsciiDocOption(1, "Map from package names to a URL base to use for links", "-link", "link"){

            @Override
            public boolean process(String option, List<String> arguments) {
                for (String arg : arguments) {
                    String[] parts;
                    for (String part : parts = arg.split(",")) {
                        AsciiDocOptions.this.linkMaps.addConfiguredBaseUrl(part);
                    }
                }
                return true;
            }
        });
        return result;
    }

    public Set<? extends Doclet.Option> getOptions() {
        return new HashSet<Doclet.Option>(this.options);
    }

    public String getDestDirName() {
        return this.destDirName;
    }

    public Set<String> getIncludeClasses() {
        return Collections.unmodifiableSet(this.includeClasses);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="The link map may be modified")
    public AsciiDocLinkMaps getLinkMaps() {
        return this.linkMaps;
    }
}

