/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.params4j.doclet;

import com.sun.source.doctree.ReferenceTree;
import com.sun.source.util.DocTreePath;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor14;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;
import uk.co.spudsoft.params4j.doclet.AsciiDocLinkMaps;

public class TypeWriter {
    private final Writer writer;
    private final Reporter reporter;
    private final Set<String> includedClasses;
    private final AsciiDocLinkMaps linkMaps;
    private static final Pattern LEADING_PACKAGE = Pattern.compile("^([a-z][a-zA-Z0-9]+\\.)");
    private static final Pattern TYPE_PARAMS = Pattern.compile("(<[^<]+>)");
    private static final Pattern SQUARE_BRACKET = Pattern.compile("\\]");
    private static final Pattern CONSTRUCTOR = Pattern.compile("^([a-zA-Z0-9]+)#\\1");

    public void writeReferenceTree(DocletEnvironment environment, DocTreePath currentPath, ReferenceTree refTree) {
        Element element = environment.getDocTrees().getElement(new DocTreePath(currentPath, refTree));
        if (element instanceof ExecutableElement) {
            TypeElement typeElement = (TypeElement)element.getEnclosingElement();
            ExecutableElement methodElement = (ExecutableElement)element;
            String url = this.linkMaps.getUrlForType(this.reporter, TypeWriter.getPackage(typeElement), TypeWriter.getClassName(typeElement));
            if (url == null) {
                if (this.includedClasses.contains(typeElement.getQualifiedName().toString())) {
                    this.write("xref:");
                    this.write(typeElement.getQualifiedName().toString());
                    this.write(".adoc[");
                    this.write(TypeWriter.simplifySignature(refTree.getSignature()));
                    this.write("] ");
                } else {
                    this.write(refTree.getSignature());
                    this.write(" ");
                }
            } else {
                this.write("link:");
                this.write(this.linkMaps.getUrlForType(this.reporter, TypeWriter.getPackage(typeElement), TypeWriter.getClassName(typeElement)));
                this.write(TypeWriter.getMethodAnchor(methodElement));
                this.write("[");
                this.write(TypeWriter.simplifySignature(refTree.getSignature()));
                this.write("] ");
            }
        } else if (element instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            String url = this.linkMaps.getUrlForType(this.reporter, TypeWriter.getPackage(typeElement), TypeWriter.getClassName(typeElement));
            if (url == null) {
                if (this.includedClasses.contains(typeElement.getQualifiedName().toString())) {
                    this.write("xref:");
                    this.write(typeElement.getQualifiedName().toString());
                    this.write(".adoc[");
                    this.write(refTree.getSignature());
                    this.write("] ");
                } else {
                    this.write(refTree.getSignature());
                    this.write(" ");
                }
            } else {
                this.write("link:");
                this.write(this.linkMaps.getUrlForType(this.reporter, TypeWriter.getPackage(element), TypeWriter.getClassName(element)));
                this.write("[");
                this.write(refTree.getSignature());
                this.write("] ");
            }
        }
    }

    public void writeDeclaredType(DeclaredType declaredType) {
        TypeElement typeElement = (TypeElement)declaredType.asElement();
        String url = this.linkMaps.getUrlForType(this.reporter, TypeWriter.getPackage(typeElement), TypeWriter.getClassName(typeElement));
        if (url != null) {
            this.write("link:");
            this.write(url);
            this.write("[");
            this.write(typeElement.getSimpleName().toString());
            this.write("]");
        } else if (this.includedClasses.contains(typeElement.getQualifiedName().toString())) {
            this.write("xref:");
            this.write(typeElement.getQualifiedName().toString());
            this.write(".adoc[");
            this.write(typeElement.getSimpleName().toString());
            this.write("]");
        } else {
            this.write(declaredType.toString());
        }
        if (!declaredType.getTypeArguments().isEmpty()) {
            this.write("<");
            boolean first = true;
            for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
                if (!first) {
                    this.write(", ");
                }
                first = false;
                if (typeMirror instanceof DeclaredType) {
                    this.writeDeclaredType((DeclaredType)typeMirror);
                    continue;
                }
                if (typeMirror == null) continue;
                this.write(typeMirror.toString());
            }
            this.write(">");
        }
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Objects are not POJOs and may be accessed (and modified) during the life of this object")
    public TypeWriter(Writer writer, Reporter reporter, Set<String> includedClasses, AsciiDocLinkMaps linkMaps) {
        this.writer = writer;
        this.reporter = reporter;
        this.includedClasses = includedClasses;
        this.linkMaps = linkMaps;
    }

    public static String getPackage(Element elem) {
        while (elem != null && !(elem instanceof PackageElement)) {
            elem = elem.getEnclosingElement();
        }
        if (elem != null) {
            return ((PackageElement)elem).getQualifiedName().toString();
        }
        return null;
    }

    public static String getMethodAnchor(ExecutableElement methodElement) {
        StringBuilder builder = new StringBuilder();
        builder.append("#");
        builder.append(methodElement.getSimpleName());
        builder.append("(");
        boolean first = true;
        for (VariableElement variableElement : methodElement.getParameters()) {
            if (!first) {
                builder.append(",");
            }
            first = false;
            String type = variableElement.asType().accept(new SimpleTypeVisitor14<String, Void>(){

                @Override
                public String visitDeclared(DeclaredType t, Void p) {
                    return t.asElement().toString();
                }

                @Override
                public String visitArray(ArrayType t, Void p) {
                    return t.toString().replaceAll("\\[\\]", "%5B%5D");
                }

                @Override
                public String visitPrimitive(PrimitiveType t, Void p) {
                    return t.toString();
                }
            }, null);
            builder.append(type);
        }
        builder.append(")");
        return builder.toString();
    }

    public static String getBaseClassName(Element elem) {
        Element lastElem = elem;
        while (elem instanceof TypeElement) {
            if (!((elem = elem.getEnclosingElement()) instanceof TypeElement)) continue;
            lastElem = elem;
        }
        return lastElem.getSimpleName().toString();
    }

    public static String getClassName(Element elem) {
        StringBuilder builder = new StringBuilder();
        while (elem instanceof TypeElement) {
            if (!builder.isEmpty()) {
                builder.insert(0, ".");
            }
            builder.insert(0, elem.getSimpleName());
            elem = elem.getEnclosingElement();
        }
        return builder.toString();
    }

    public static String simplifySignature(String signature) {
        Matcher matcher;
        while ((matcher = LEADING_PACKAGE.matcher(signature)).find()) {
            signature = matcher.replaceAll("");
        }
        Matcher tpm = TYPE_PARAMS.matcher(signature);
        while (tpm.find()) {
            signature = tpm.replaceAll("");
            tpm = TYPE_PARAMS.matcher(signature);
        }
        signature = SQUARE_BRACKET.matcher(signature).replaceAll("\\\\]");
        signature = CONSTRUCTOR.matcher(signature).replaceAll(mr -> mr.group(1));
        return signature.trim();
    }

    private void write(String s) {
        s = s.replaceAll("\n ", "\n");
        try {
            this.writer.write(s);
        }
        catch (IOException ex) {
            this.reporter.print(Diagnostic.Kind.ERROR, "Failed to write: " + ex.getMessage());
        }
    }
}

