/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.params4j.impl;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsSchema;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import uk.co.spudsoft.params4j.ParameterGatherer;
import uk.co.spudsoft.params4j.Params4JSpi;

public class CommandLineArgumentsGatherer<P>
implements ParameterGatherer<P> {
    private final Map<String, String> args;
    private final String namePrefix;

    public CommandLineArgumentsGatherer(String[] args, String namePrefix) {
        this.args = this.argsToMap(args);
        this.namePrefix = namePrefix;
    }

    final Map<String, String> argsToMap(String[] args) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String arg : args) {
            String[] parts = arg.split("=", 2);
            if (parts.length == 1) {
                result.put(arg, "true");
                continue;
            }
            result.put(parts[0], parts[1]);
        }
        return result;
    }

    @Override
    public P gatherParameters(Params4JSpi spi, P base) throws IOException {
        ObjectReader reader = spi.getPropsMapper().readerForUpdating(base).with((FormatSchema)new JavaPropsSchema().withPathSeparatorEscapeChar('\\'));
        byte[] props = spi.prepareProperties("Command line arguments", this.args.entrySet(), Map.Entry::getKey, Map.Entry::getValue, this.namePrefix);
        if (props.length > 0) {
            return (P)reader.readValue(props);
        }
        return base;
    }

    public String toString() {
        return "Command line arguments";
    }
}

