/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.params4j.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultParametersErrorHandler
extends DeserializationProblemHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultParametersErrorHandler.class);

    public Object handleUnexpectedToken(DeserializationContext ctxt, JavaType targetType, JsonToken t, JsonParser p, String failureMsg) throws IOException {
        logger.warn("Unexpected token: {} at {}: {}", new Object[]{targetType, this.buildLocation(ctxt.getParser()), failureMsg});
        return null;
    }

    public boolean handleUnknownProperty(DeserializationContext ctxt, JsonParser p, JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException {
        logger.warn("Unknown property: {} at {} with value {}", new Object[]{propertyName, this.buildLocation(ctxt.getParser()), p.readValueAsTree()});
        return true;
    }

    public Object handleWeirdNativeValue(DeserializationContext ctxt, JavaType targetType, Object valueToConvert, JsonParser p) throws IOException {
        logger.warn("Unprocessable native value : {} \"{}\": Cannot convert to {}", new Object[]{this.buildLocation(ctxt.getParser()), targetType, valueToConvert, targetType});
        return null;
    }

    public Object handleWeirdNumberValue(DeserializationContext ctxt, Class<?> targetType, Number valueToConvert, String failureMsg) throws IOException {
        logger.warn("Unprocessable number value : {} \"{}\": {}", new Object[]{this.buildLocation(ctxt.getParser()), targetType, valueToConvert, failureMsg});
        return null;
    }

    public Object handleWeirdStringValue(DeserializationContext ctxt, Class<?> targetType, String valueToConvert, String failureMsg) throws IOException {
        logger.warn("Unprocessable string value : {} \"{}\": {}", new Object[]{this.buildLocation(ctxt.getParser()), valueToConvert, failureMsg});
        return null;
    }

    private String buildLocation(JsonParser parser) {
        ArrayList<String> names = new ArrayList<String>();
        for (JsonStreamContext streamContext = parser.getParsingContext(); streamContext != null; streamContext = streamContext.getParent()) {
            if (streamContext.getCurrentName() == null) continue;
            names.add(streamContext.getCurrentName());
        }
        Collections.reverse(names);
        return String.join((CharSequence)".", names);
    }
}

