/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.params4j.impl;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatcher {
    private static final Logger logger = LoggerFactory.getLogger(FileWatcher.class);
    private static final int NOTIFICATION_DELAY_S = 2;
    private static final int DEFAULT_DELAY_S = 3600;
    private final AtomicReference<Thread> threadRef = new AtomicReference();
    private final WatchService watcher;
    private final Runnable callback;
    private Map<Path, WatchKey> watchKeys = new HashMap<Path, WatchKey>();

    public FileWatcher(Runnable callback) {
        WatchService tempWatchService = null;
        try {
            tempWatchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException ex) {
            logger.error("Failed to create watch service, configuration changes will not be noticed: ", (Throwable)ex);
        }
        this.watcher = tempWatchService;
        this.callback = callback;
    }

    public void watch(Path path) throws IOException {
        if (this.watcher != null && !this.watchKeys.containsKey(path)) {
            WatchKey key = path.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            this.watchKeys.put(path, key);
        }
    }

    public boolean start() {
        if (!this.watchKeys.isEmpty()) {
            Thread thread;
            Thread oldThread;
            if (this.threadRef.get() == null && (oldThread = this.threadRef.compareAndExchange(null, thread = new Thread(this::eventLoop, "Params4JFileWatcher"))) == null) {
                thread.start();
            }
            return true;
        }
        return false;
    }

    private void eventLoop() {
        int pollDelay = 3600;
        while (true) {
            WatchKey key;
            try {
                key = this.watcher.poll(pollDelay, TimeUnit.SECONDS);
            }
            catch (InterruptedException x) {
                return;
            }
            logger.trace("Poll completed, key: {}, pollDelay: {}", (Object)key, (Object)pollDelay);
            if (key == null) {
                if (2 != pollDelay) continue;
                this.callback.run();
                pollDelay = 3600;
                continue;
            }
            key.pollEvents();
            pollDelay = 2;
            key.reset();
        }
    }
}

