/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.params4j.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import uk.co.spudsoft.params4j.JavadocCapture;

@SupportedAnnotationTypes(value={"uk.co.spudsoft.params4j.JavadocCapture"})
public class JavadocCapturer
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annnotations, RoundEnvironment re) {
        for (TypeElement typeElement : annnotations) {
            if (!typeElement.getQualifiedName().toString().equals(JavadocCapture.class.getName())) continue;
            for (Element element : re.getElementsAnnotatedWith(typeElement)) {
                if (element.getKind() != ElementKind.CLASS) continue;
                this.generateCommentProperties(new HashSet<String>(), (TypeElement)element);
            }
        }
        return true;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private void writeDocProperties(PackageElement packageElement, TypeElement classElement, Properties commentProps) {
        try {
            FileObject fo = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, packageElement.getQualifiedName(), String.valueOf(classElement.getSimpleName()) + "-doc.properties", classElement);
            try (OutputStream out = fo.openOutputStream();){
                commentProps.store(out, "Documentation properties for " + String.valueOf(classElement.getQualifiedName()));
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.OTHER, "Output written to " + String.valueOf(fo.toUri()));
        }
        catch (IOException ex) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unable to write to resource file: " + ex.getMessage());
        }
    }

    private PackageElement getPackage(Element element) {
        if (element.getKind() == ElementKind.PACKAGE) {
            return (PackageElement)element;
        }
        Element parent = element.getEnclosingElement();
        if (parent != null) {
            return this.getPackage(parent);
        }
        return null;
    }

    public static String setterNameToVariableName(String setterName) {
        if (setterName == null) {
            return null;
        }
        if (((String)setterName).startsWith("set") && ((String)setterName).length() > 3 && Character.isUpperCase(((String)setterName).codePointAt(3))) {
            setterName = ((String)setterName).substring(3);
        }
        if (Character.isUpperCase(((String)setterName).codePointAt(0))) {
            setterName = Character.toString(Character.toLowerCase(((String)setterName).codePointAt(0))) + ((String)setterName).substring(((String)setterName).offsetByCodePoints(0, 1));
        }
        return setterName;
    }

    public static String getterNameToVariableName(String getterName) {
        if (getterName == null) {
            return null;
        }
        if (((String)getterName).startsWith("get") && ((String)getterName).length() > 3 && Character.isUpperCase(((String)getterName).codePointAt(3))) {
            getterName = ((String)getterName).substring(3);
        }
        if (((String)getterName).startsWith("is") && ((String)getterName).length() > 2 && Character.isUpperCase(((String)getterName).codePointAt(2))) {
            getterName = ((String)getterName).substring(2);
        }
        if (Character.isUpperCase(((String)getterName).codePointAt(0))) {
            getterName = Character.toString(Character.toLowerCase(((String)getterName).codePointAt(0))) + ((String)getterName).substring(((String)getterName).offsetByCodePoints(0, 1));
        }
        return getterName;
    }

    static String tidyComment(String comment) {
        if (comment == null) {
            return null;
        }
        if ((comment = comment.split("\n")[0].trim()).startsWith("The ") || comment.startsWith("the ")) {
            comment = comment.substring(4);
        }
        if (comment.endsWith(".")) {
            comment = comment.substring(0, comment.length() - 1);
        }
        return comment.trim();
    }

    private void generateCommentProperties(Set<String> elements, TypeElement element) {
        Properties commentProps = new Properties();
        if (elements.add(element.getQualifiedName().toString())) {
            for (Element element2 : element.getEnclosedElements()) {
                String childName = element2.getSimpleName().toString();
                if (element2.getKind() == ElementKind.FIELD) {
                    String docComment;
                    if (!commentProps.containsKey(childName) && (docComment = JavadocCapturer.tidyComment(this.processingEnv.getElementUtils().getDocComment(element2))) != null && !docComment.isEmpty()) {
                        commentProps.put(childName, docComment);
                    }
                    DeclaredType parameterClass = null;
                    VariableElement variable = (VariableElement)element2;
                    if (variable.asType() instanceof DeclaredType) {
                        parameterClass = (DeclaredType)variable.asType();
                    }
                    if (parameterClass == null) continue;
                    this.generateCommentProperties(elements, (TypeElement)parameterClass.asElement());
                    continue;
                }
                if (element2.getKind() == ElementKind.METHOD) {
                    ExecutableElement method = (ExecutableElement)element2;
                    if (method.getParameters().size() != 1 || !childName.startsWith("set")) continue;
                    VariableElement parameter = method.getParameters().get(0);
                    DeclaredType parameterClass = null;
                    if (parameter.asType() instanceof DeclaredType) {
                        parameterClass = (DeclaredType)parameter.asType();
                    }
                    String variableName = JavadocCapturer.setterNameToVariableName(childName);
                    String docComment = JavadocCapturer.tidyComment(this.processingEnv.getElementUtils().getDocComment(method));
                    if (docComment != null && !docComment.isEmpty()) {
                        commentProps.put(variableName, docComment);
                    }
                    if (parameterClass == null) continue;
                    this.generateCommentProperties(elements, (TypeElement)parameterClass.asElement());
                    continue;
                }
                if (element2.getKind() != ElementKind.CLASS) continue;
                this.generateCommentProperties(elements, (TypeElement)element2);
            }
            if (!commentProps.isEmpty()) {
                this.writeDocProperties(this.getPackage(element), element, commentProps);
            }
        }
    }
}

