/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.params4j.impl;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import uk.co.spudsoft.params4j.FileType;
import uk.co.spudsoft.params4j.ParameterGatherer;
import uk.co.spudsoft.params4j.Params4J;
import uk.co.spudsoft.params4j.Params4JFactory;
import uk.co.spudsoft.params4j.impl.CommandLineArgumentsGatherer;
import uk.co.spudsoft.params4j.impl.DirGatherer;
import uk.co.spudsoft.params4j.impl.EnvironmentVariablesGatherer;
import uk.co.spudsoft.params4j.impl.MixIn;
import uk.co.spudsoft.params4j.impl.Params4JImpl;
import uk.co.spudsoft.params4j.impl.ResourceGatherer;
import uk.co.spudsoft.params4j.impl.SecretsGatherer;
import uk.co.spudsoft.params4j.impl.SystemPropertiesGatherer;

public class Params4JFactoryImpl<P>
implements Params4JFactory<P> {
    private Supplier<P> constructor;
    private List<ParameterGatherer<P>> gatherers = new ArrayList<ParameterGatherer<P>>();
    private DeserializationProblemHandler problemHandler;
    private JavaPropsMapper propsMapper;
    private ObjectMapper jsonMapper;
    private List<Module> customJsonModules = new ArrayList<Module>();
    private List<MixIn> mixIns = new ArrayList<MixIn>();
    private ObjectMapper yamlMapper;

    @Override
    public Params4JFactory<P> withConstructor(Supplier<P> supplier) {
        this.constructor = supplier;
        return this;
    }

    @Override
    public Params4JFactory<P> withGatherer(ParameterGatherer<P> gatherer) {
        this.gatherers.add(gatherer);
        return this;
    }

    @Override
    public Params4JFactory<P> withProblemHandler(DeserializationProblemHandler problemHandler) {
        this.problemHandler = problemHandler;
        return this;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Externable object is mutable")
    public Params4JFactory<P> withPropsMapper(JavaPropsMapper propsMapper) {
        this.propsMapper = propsMapper;
        return this;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Externable object is mutable")
    public Params4JFactory<P> withJsonMapper(ObjectMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        return this;
    }

    @Override
    public Params4JFactory<P> withCustomJsonModule(Module module) {
        this.customJsonModules.add(module);
        return this;
    }

    @Override
    public Params4JFactory<P> withMixIn(Class<?> target, Class<?> mixinSource) {
        this.mixIns.add(new MixIn(target, mixinSource));
        return this;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Externable object is mutable")
    public Params4JFactory<P> withYamlMapper(ObjectMapper yamlMapper) {
        this.yamlMapper = yamlMapper;
        return this;
    }

    @Override
    public Params4JFactory<P> withResourceGatherer(String resource, FileType fileType) {
        return this.withGatherer(new ResourceGatherer(resource, fileType));
    }

    @Override
    public Params4JFactory<P> withDirGatherer(File dir, FileType ... fileTypes) {
        return this.withGatherer(new DirGatherer(dir, fileTypes));
    }

    @Override
    public Params4JFactory<P> withEnvironmentVariablesGatherer(String namePrefix, boolean toLowerCase) {
        return this.withGatherer(new EnvironmentVariablesGatherer(namePrefix, toLowerCase));
    }

    @Override
    public Params4JFactory<P> withSystemPropertiesGatherer(String namePrefix) {
        return this.withGatherer(new SystemPropertiesGatherer(namePrefix));
    }

    @Override
    public Params4JFactory<P> withCommandLineArgumentsGatherer(String[] args, String namePrefix) {
        return this.withGatherer(new CommandLineArgumentsGatherer(args, namePrefix));
    }

    @Override
    public Params4JFactory<P> withSecretsGatherer(Path root, int fileSizeLimit, int fileCountLimit, int fileDepthLimit, Charset charset) {
        return this.withGatherer(new SecretsGatherer(root, fileSizeLimit, fileCountLimit, fileDepthLimit, charset));
    }

    @Override
    public Params4J<P> create() {
        return new Params4JImpl<P>(this.constructor, Collections.unmodifiableList(this.gatherers), this.problemHandler, this.propsMapper, this.jsonMapper, this.customJsonModules, this.mixIns, this.yamlMapper);
    }
}

