/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.params4j.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.spudsoft.params4j.Comment;
import uk.co.spudsoft.params4j.ConfigurationProperty;
import uk.co.spudsoft.params4j.ParameterGatherer;
import uk.co.spudsoft.params4j.Params4J;
import uk.co.spudsoft.params4j.Params4JSpi;
import uk.co.spudsoft.params4j.impl.DefaultParametersErrorHandler;
import uk.co.spudsoft.params4j.impl.FileWatcher;
import uk.co.spudsoft.params4j.impl.JavadocCapturer;
import uk.co.spudsoft.params4j.impl.MixIn;

public final class Params4JImpl<P>
implements Params4J<P>,
Params4JSpi {
    private static final Logger logger = LoggerFactory.getLogger(Params4JImpl.class);
    private final Supplier<P> constructor;
    private final List<ParameterGatherer<P>> gatherers;
    private final DeserializationProblemHandler problemHandler;
    private final JavaPropsMapper propsMapper;
    private final ObjectMapper jsonMapper;
    private final ObjectMapper yamlMapper;
    private final FileWatcher fileWatcher;
    private Consumer<P> changeHappenedHandler;
    private final Object lock = new Object();
    private final AtomicReference<ObjectNode> lastValue = new AtomicReference();
    private static final Set<String> TERMINAL_TYPES = Params4JImpl.buildTerminalTypes();

    static Set<String> buildTerminalTypes() {
        HashSet<String> tt = new HashSet<String>();
        tt.add("java.time.LocalDateTime");
        tt.add("java.time.LocalDate");
        tt.add("java.time.LocalTime");
        tt.add("java.time.Duration");
        tt.add("java.lang.String");
        tt.add("java.lang.Integer");
        tt.add("java.lang.Long");
        tt.add("java.io.File");
        tt.add("java.util.regex.Pattern");
        return Collections.unmodifiableSet(tt);
    }

    private JavaPropsMapper createPropsMapper(List<Module> customJsonModules, List<MixIn> mixIns) {
        JavaPropsMapper mapper = (JavaPropsMapper)((JavaPropsMapper.Builder)JavaPropsMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).build();
        return this.configureObjectMapper(mapper, customJsonModules, mixIns);
    }

    private ObjectMapper createYamlMapper(List<Module> customJsonModules, List<MixIn> mixIns) {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return this.configureObjectMapper(mapper, customJsonModules, mixIns);
    }

    private ObjectMapper createJsonMapper(List<Module> customJsonModules, List<MixIn> mixIns) {
        ObjectMapper mapper = new ObjectMapper();
        return this.configureObjectMapper(mapper, customJsonModules, mixIns);
    }

    private <T extends ObjectMapper> T configureObjectMapper(T mapper, List<Module> customJsonModules, List<MixIn> mixIns) {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        if (customJsonModules != null) {
            for (Module module : customJsonModules) {
                mapper.registerModule(module);
            }
        }
        if (mixIns != null) {
            for (MixIn mixIn : mixIns) {
                mapper.addMixIn(mixIn.target, mixIn.source);
            }
        }
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.setDefaultMergeable(Boolean.TRUE);
        mapper.addHandler(this.problemHandler);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        return mapper;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Externable objects are mutable")
    public Params4JImpl(Supplier<P> constructor, List<ParameterGatherer<P>> gatherers, DeserializationProblemHandler problemHandler, JavaPropsMapper propsMapper, ObjectMapper jsonMapper, List<Module> customJsonModules, List<MixIn> mixIns, ObjectMapper yamlMapper) {
        Objects.requireNonNull(constructor, "A valid supplier must be set on the factory");
        Objects.requireNonNull(gatherers, "A set of gatherers must be set on the factory");
        this.constructor = constructor;
        this.gatherers = gatherers;
        this.problemHandler = Objects.requireNonNullElseGet(problemHandler, () -> new DefaultParametersErrorHandler());
        this.propsMapper = Objects.requireNonNullElseGet(propsMapper, () -> this.createPropsMapper(customJsonModules, mixIns));
        this.jsonMapper = Objects.requireNonNullElseGet(jsonMapper, () -> this.createJsonMapper(customJsonModules, mixIns));
        this.yamlMapper = Objects.requireNonNullElseGet(yamlMapper, () -> this.createYamlMapper(customJsonModules, mixIns));
        this.fileWatcher = new FileWatcher(this::changeNotificationHandler);
    }

    public DeserializationProblemHandler getProblemHandler() {
        return this.problemHandler;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Externable object is mutable")
    public JavaPropsMapper getPropsMapper() {
        return this.propsMapper;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Externable object is mutable")
    public ObjectMapper getJsonMapper() {
        return this.jsonMapper;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Externable object is mutable")
    public ObjectMapper getYamlMapper() {
        return this.yamlMapper;
    }

    @Override
    public void watch(Path path) throws IOException {
        this.fileWatcher.watch(path);
    }

    @Override
    public <T> byte[] prepareProperties(String name, Collection<T> entries, Function<T, Object> keyGetter, Function<T, Object> valueGetter, String propertyPrefix) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8);){
                for (T entry : entries) {
                    try {
                        String key = this.getKeyAsPrefixedString(keyGetter, entry, propertyPrefix);
                        if (key != null) {
                            String value = (String)valueGetter.apply(entry);
                            logger.debug("{}: {} = {}", new Object[]{name, key, value});
                            writer.append(key).append(" = ").append(value).append("\r\n");
                            continue;
                        }
                        logger.trace("{}: skipping entry: {}", (Object)name, entry);
                    }
                    catch (ClassCastException ex) {
                        logger.warn("{} unable to get key or value as a string from {}", (Object)name, entry);
                    }
                }
            }
            if (logger.isTraceEnabled()) {
                logger.warn("{}: result as properties: {}", (Object)name, (Object)baos.toString(StandardCharsets.UTF_8));
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    private <T> String getKeyAsPrefixedString(Function<T, Object> keyGetter, T entry, String propertyPrefix) {
        String castKey = (String)keyGetter.apply(entry);
        String key = null;
        if (propertyPrefix == null || propertyPrefix.isEmpty()) {
            key = castKey;
        } else if (castKey.startsWith(propertyPrefix)) {
            key = castKey.substring(propertyPrefix.length());
        }
        return key;
    }

    @Override
    public P gatherParameters() {
        P value = this.constructor.get();
        for (ParameterGatherer<P> gatherer : this.gatherers) {
            try {
                value = gatherer.gatherParameters(this, value);
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Parameters after {}: {}", gatherer, (Object)this.jsonMapper.writeValueAsString(value));
            }
            catch (Throwable ex) {
                logger.warn("Failed to process: ", ex);
            }
        }
        this.lastValue.set((ObjectNode)this.jsonMapper.convertValue(value, ObjectNode.class));
        return value;
    }

    @Override
    public boolean notifyOfChanges(Consumer<P> handler) {
        this.changeHappenedHandler = handler;
        return this.fileWatcher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeNotificationHandler() {
        Object object = this.lock;
        synchronized (object) {
            P newValue = this.gatherParameters();
            ObjectNode newNode = (ObjectNode)this.jsonMapper.convertValue(newValue, ObjectNode.class);
            if (newNode.equals((Object)this.lastValue.get())) {
                this.lastValue.set(newNode);
                this.changeHappenedHandler.accept(newValue);
            }
        }
    }

    private static boolean canBeEnvVar(String propName) {
        return !propName.contains("[") && !propName.contains("]");
    }

    private Object getValue(Object object, Field field) {
        if (object == null || field == null) {
            return null;
        }
        try {
            if (field.canAccess(object)) {
                return field.get(object);
            }
            field.setAccessible(true);
            Object value = field.get(object);
            field.setAccessible(false);
            return value;
        }
        catch (Throwable ex) {
            logger.debug("Failed to get {} from {}: {}", new Object[]{field, object, ex.getMessage()});
            return null;
        }
    }

    private Object getValue(Object object, String setterName) {
        if (object == null || setterName == null || setterName.length() < 4) {
            return null;
        }
        Method method = null;
        try {
            method = object.getClass().getMethod("get" + setterName.substring(3), new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (method == null) {
            try {
                method = object.getClass().getMethod("is" + setterName.substring(3), new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (method == null) {
            logger.debug("No method {} or {} on {}", new Object[]{"get" + setterName.substring(3), "is" + setterName.substring(3), object.getClass()});
            return null;
        }
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (Throwable ex) {
            logger.debug("Failed to execute {}.{} on {}: {}", new Object[]{object.getClass().getSimpleName(), method, object, ex.getMessage()});
            return null;
        }
    }

    private Properties loadDocProperties(Map<String, Properties> docProperties, Class<?> type) {
        Properties props = docProperties.get(type.getCanonicalName());
        if (props == null) {
            try (InputStream stream = type.getResourceAsStream(type.getSimpleName() + "-doc.properties");){
                props = new Properties();
                props.load(stream);
                docProperties.put(type.getCanonicalName(), props);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return props;
    }

    @Override
    public List<ConfigurationProperty> getDocumentation(P defaultInstance, String prefix, List<Pattern> terminalClasses, List<Pattern> undocumentedClasses) {
        ArrayList<ConfigurationProperty> result = new ArrayList<ConfigurationProperty>();
        this.walkSetters(result, new HashMap<String, Properties>(), prefix, defaultInstance, defaultInstance.getClass(), new Stack<PropertyState>(), terminalClasses, undocumentedClasses);
        return result;
    }

    private boolean typeIsIn(List<Pattern> list, String typeName) {
        if (list == null || list.isEmpty() || typeName == null) {
            return false;
        }
        for (Pattern pattern : list) {
            if (!pattern.matcher(typeName).matches()) continue;
            return true;
        }
        return false;
    }

    private <T> void walkSetters(List<ConfigurationProperty> properties, Map<String, Properties> docProperties, String prefix, T defaultInstance, Class<?> clazz, Stack<PropertyState> propertyStates, List<Pattern> terminalClasses, List<Pattern> undocumentedClasses) throws SecurityException {
        Object defaultValue;
        String fieldName;
        Class<?> fieldType;
        Properties classDocProperties = this.loadDocProperties(docProperties, clazz);
        HashSet<String> propsDone = new HashSet<String>();
        for (Method method : clazz.getMethods()) {
            if (method.getParameters().length != 1 || !method.getName().startsWith("set") || (method.getModifiers() & 2) != 0) continue;
            Parameter parameter = method.getParameters()[0];
            Class<?> fieldType2 = parameter.getType();
            String fieldName2 = JavadocCapturer.setterNameToVariableName(method.getName());
            Object defaultValue2 = this.getValue(defaultInstance, method.getName());
            propsDone.add(fieldName2);
            this.documentField(properties, docProperties, classDocProperties, prefix, propertyStates, terminalClasses, undocumentedClasses, method, fieldName2, fieldType2, defaultValue2, () -> (ParameterizedType)parameter.getParameterizedType());
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
            fieldType = ((Field)accessibleObject).getType();
            fieldName = ((Field)accessibleObject).getName();
            defaultValue = this.getValue(defaultInstance, (Field)accessibleObject);
            if (propsDone.contains(fieldName) || (((Field)accessibleObject).getModifiers() & 2) != 0) continue;
            this.documentField(properties, docProperties, classDocProperties, prefix, propertyStates, terminalClasses, undocumentedClasses, accessibleObject, fieldName, fieldType, defaultValue, () -> Params4JImpl.lambda$walkSetters$5((Field)accessibleObject));
        }
        for (AccessibleObject accessibleObject : clazz.getMethods()) {
            if (((Executable)accessibleObject).getParameters().length != 0 || !((Method)accessibleObject).getName().startsWith("get") && !((Method)accessibleObject).getName().startsWith("is") || (((Method)accessibleObject).getModifiers() & 2) != 0 || ((Method)accessibleObject).getDeclaringClass().equals(Object.class)) continue;
            fieldType = ((Method)accessibleObject).getReturnType();
            fieldName = JavadocCapturer.getterNameToVariableName(((Method)accessibleObject).getName());
            if (propsDone.contains(fieldName)) continue;
            defaultValue = this.getValue(defaultInstance, ((Method)accessibleObject).getName());
            propsDone.add(fieldName);
            this.documentField(properties, docProperties, classDocProperties, prefix, propertyStates, terminalClasses, undocumentedClasses, accessibleObject, fieldName, fieldType, defaultValue, () -> Params4JImpl.lambda$walkSetters$6((Method)accessibleObject));
        }
    }

    private void documentField(List<ConfigurationProperty> properties, Map<String, Properties> docProperties, Properties classDocProperties, String prefix, Stack<PropertyState> propertyStates, List<Pattern> terminalClasses, List<Pattern> undocumentedClasses, AnnotatedElement annotatedElement, String fieldName, Class<?> fieldType, Object defaultValue, Supplier<ParameterizedType> parameterizedTypeGetter) throws SecurityException {
        String fieldTypeName = fieldType.getCanonicalName();
        boolean undocumented = this.typeIsIn(undocumentedClasses, fieldTypeName);
        boolean isListedTerminalClass = this.typeIsIn(terminalClasses, fieldTypeName);
        if (fieldType.isPrimitive() || undocumented || TERMINAL_TYPES.contains(fieldTypeName) || isListedTerminalClass) {
            this.outputTerminalField(propertyStates, fieldName, annotatedElement, classDocProperties, undocumented, defaultValue, prefix, fieldType, properties);
        } else if (Map.class.isAssignableFrom(fieldType)) {
            Type[] actualTypeArguments;
            ParameterizedType paramType = parameterizedTypeGetter.get();
            if (paramType != null && (actualTypeArguments = paramType.getActualTypeArguments()).length == 2 && actualTypeArguments[1] instanceof Class) {
                PropertyState ps = new PropertyState(fieldName, classDocProperties.getProperty(fieldName), fieldType);
                propertyStates.push(ps);
                this.documentField(properties, docProperties, classDocProperties, prefix, propertyStates, terminalClasses, undocumentedClasses, annotatedElement, "<xxx>", (Class)actualTypeArguments[1], null, parameterizedTypeGetter);
                propertyStates.pop();
            }
        } else if (List.class.isAssignableFrom(fieldType)) {
            Type[] actualTypeArguments;
            ParameterizedType paramType = parameterizedTypeGetter.get();
            if (paramType != null && (actualTypeArguments = paramType.getActualTypeArguments()).length == 1 && actualTypeArguments[0] instanceof Class) {
                PropertyState ps = new PropertyState(fieldName, classDocProperties.getProperty(fieldName), fieldType);
                propertyStates.push(ps);
                this.documentField(properties, docProperties, classDocProperties, prefix, propertyStates, terminalClasses, undocumentedClasses, annotatedElement, "[<n>]", (Class)actualTypeArguments[0], null, parameterizedTypeGetter);
                propertyStates.pop();
            }
        } else {
            boolean found = false;
            for (PropertyState ps : propertyStates) {
                if (ps.clazz != fieldType) continue;
                found = true;
            }
            if (!found) {
                PropertyState ps = new PropertyState(fieldName, classDocProperties.getProperty(fieldName), fieldType);
                propertyStates.push(ps);
                this.walkSetters(properties, docProperties, prefix, defaultValue, fieldType, propertyStates, terminalClasses, undocumentedClasses);
                propertyStates.pop();
            }
        }
    }

    private void outputTerminalField(Stack<PropertyState> propertyStates, String name, AnnotatedElement element, Properties classDocProperties, boolean undocumented, Object defaultValue, String prefix, Class<?> type, List<ConfigurationProperty> properties) {
        Object propName = propertyStates.stream().map(ps -> ps.name).collect(Collectors.joining("."));
        if (propName != null && !((String)propName).isEmpty() && !name.startsWith("[")) {
            propName = (String)propName + ".";
        }
        propName = (String)propName + name;
        String newComment = null;
        if (element.isAnnotationPresent(Comment.class)) {
            newComment = element.getAnnotation(Comment.class).value();
        }
        if (newComment == null || newComment.isEmpty()) {
            newComment = classDocProperties.getProperty(name);
        }
        Object comment = propertyStates.stream().map(ps -> ps.comment).filter(c -> c != null).collect(Collectors.joining(", "));
        if (newComment != null && !newComment.isEmpty() && classDocProperties.containsKey(name)) {
            comment = comment != null && !((String)comment).isEmpty() ? (String)comment + ", " + newComment : newComment;
        }
        ConfigurationProperty prop = ConfigurationProperty.builder().canBeEnvVar(Params4JImpl.canBeEnvVar((String)propName)).undocumented(undocumented).comment((String)comment).defaultValue(defaultValue == null ? null : defaultValue.toString()).name((String)(prefix == null ? propName : prefix + (String)propName)).type(type).build();
        properties.add(prop);
        logger.debug("Added property {} (resulting in {} entries)", (Object)prop, (Object)properties.size());
    }

    private static /* synthetic */ ParameterizedType lambda$walkSetters$6(Method method) {
        Type genericType = method.getGenericReturnType();
        if (genericType instanceof ParameterizedType) {
            return (ParameterizedType)genericType;
        }
        return null;
    }

    private static /* synthetic */ ParameterizedType lambda$walkSetters$5(Field field) {
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            return (ParameterizedType)genericType;
        }
        return null;
    }

    private static class PropertyState {
        final String name;
        final String comment;
        final Class<?> clazz;

        PropertyState(String name, String comment, Class<?> clazz) {
            this.name = name;
            this.comment = comment;
            this.clazz = clazz;
        }
    }
}

