/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.params4j.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretsWalker
extends SimpleFileVisitor<Path> {
    private static final Logger logger = LoggerFactory.getLogger(SecretsWalker.class);
    private final Path root;
    private final ObjectMapper objectMapper;
    private final long fileSizeLimit;
    private final int fileCountLimit;
    private final Charset charset;
    private final Consumer<Path> dirHandler;
    private final ObjectNode objectNode;
    private final Map<Path, ObjectNode> nodes = new HashMap<Path, ObjectNode>();
    private ObjectNode current;
    private int fileCount;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Externable objects are mutable")
    public SecretsWalker(Path root, ObjectMapper objectMapper, int fileSizeLimit, int fileCountLimit, Charset charset, Consumer<Path> dirHandler) {
        this.root = root;
        this.objectMapper = objectMapper;
        this.current = this.objectNode = objectMapper.createObjectNode();
        this.fileSizeLimit = fileSizeLimit;
        this.fileCountLimit = fileCountLimit;
        this.charset = charset;
        this.dirHandler = dirHandler;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Externable object is mutable")
    public ObjectNode getObjectNode() {
        return this.objectNode;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        logger.trace("Leaving dir: {}", (Object)dir);
        this.current = this.nodes.get(dir);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        logger.trace("File: {}", (Object)file);
        if (attrs.isDirectory()) {
            logger.trace("Ignoring file {} because it is a directory (can be caused by max depth being exceeded)", (Object)file);
        } else {
            Path pathFileName = file.getFileName();
            if (pathFileName != null) {
                String filename = pathFileName.toString();
                if (filename.startsWith(".")) {
                    logger.trace("Ignoring file {} because it is hidden", (Object)file);
                } else if (attrs.size() > this.fileSizeLimit) {
                    logger.trace("Ignoring file {} because it is larger than the maximum size ({} > {})", new Object[]{file, attrs.size(), this.fileSizeLimit});
                } else if (++this.fileCount > this.fileCountLimit) {
                    logger.trace("Ignoring file {} because too many files have been processed ({} > {})", new Object[]{file, this.fileCount, this.fileCountLimit});
                } else {
                    try (FileInputStream fis = new FileInputStream(file.toFile());){
                        String value = new String(fis.readAllBytes(), this.charset);
                        this.current.put(filename, value);
                    }
                    catch (Throwable ex) {
                        logger.trace("Ignoring file {} because it could not be read: ", (Object)file, (Object)ex);
                    }
                }
            }
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        Path pathFileName = dir.getFileName();
        if (pathFileName != null) {
            String dirname = pathFileName.toString();
            if (dir.equals(this.root)) {
                return FileVisitResult.CONTINUE;
            }
            if (dirname.startsWith(".") || dir.equals(this.root)) {
                logger.trace("Ignoring dir {} because it is hidden", (Object)dir);
                return FileVisitResult.SKIP_SUBTREE;
            }
            logger.trace("Entering dir: {}", (Object)dir);
            if (this.dirHandler != null) {
                this.dirHandler.accept(dir);
            }
            ObjectNode dirNode = this.objectMapper.createObjectNode();
            this.current.set(dirname, (JsonNode)dirNode);
            this.nodes.put(dir, this.current);
            this.current = dirNode;
            return FileVisitResult.CONTINUE;
        }
        return FileVisitResult.TERMINATE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        logger.trace("Failed to visit: {}", (Object)file);
        return FileVisitResult.CONTINUE;
    }
}

