/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.mgmt;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.spudsoft.mgmt.RingBuffer;

public class AccessLogCaptureRoute
implements Handler<RoutingContext> {
    private static final Logger logger = LoggerFactory.getLogger(AccessLogCaptureRoute.class);
    private final RingBuffer<AccessLogData> buffer;

    public AccessLogCaptureRoute(int bufferSize) {
        this.buffer = new RingBuffer(bufferSize);
    }

    public RingBuffer<AccessLogData> getBuffer() {
        return this.buffer;
    }

    public void handle(RoutingContext context) {
        AccessLogData ald = new AccessLogData(System.currentTimeMillis(), context.request());
        this.buffer.add(ald);
        context.addBodyEndHandler(v -> {
            ald.setEndTimestamp(System.currentTimeMillis());
            ald.setResponse(context.response());
        });
        context.next();
    }

    public static class AccessLogData {
        private final long timestamp;
        private final HttpServerRequest request;
        private long endTimestamp;
        private HttpServerResponse response;

        public AccessLogData(long timestamp, HttpServerRequest request) {
            this.timestamp = timestamp;
            this.request = request;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public HttpServerRequest getRequest() {
            return this.request;
        }

        public long getEndTimestamp() {
            return this.endTimestamp;
        }

        public HttpServerResponse getResponse() {
            return this.response;
        }

        public void setEndTimestamp(long endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        public void setResponse(HttpServerResponse response) {
            this.response = response;
        }
    }
}

