/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.mgmt;

import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ContentTypes {
    public static final String PARAM = "_fmt";
    public static final String TYPE_JSON = "application/json";
    public static final String TYPE_HTML = "text/html";
    public static final String TYPE_PLAIN = "text/plain";
    public static final String TYPE_BINARY = "application/octet-stream";
    private static final Map<String, String> PARAM_TO_TYPE = ContentTypes.buildParamTypeMap();

    private static Map<String, String> buildParamTypeMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("html", TYPE_HTML);
        result.put("text", TYPE_PLAIN);
        result.put("json", TYPE_JSON);
        result.put("binary", TYPE_JSON);
        return Collections.unmodifiableMap(result);
    }

    private ContentTypes() {
    }

    public static void adjustFromParams(RoutingContext rc) {
        List values = rc.queryParam(PARAM);
        if (values != null) {
            for (String value : values) {
                String type = PARAM_TO_TYPE.get(value);
                if (type == null) continue;
                rc.setAcceptableContentType(type);
                return;
            }
        }
    }
}

