/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.mgmt;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.Json;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.util.List;
import java.util.stream.Collectors;
import uk.co.spudsoft.mgmt.ContentTypes;

public class DumpSysPropsRoute
implements Handler<RoutingContext> {
    public static final String PATH = "sysprops";

    public void standardDeploy(Router router) {
        router.route(HttpMethod.GET, "/sysprops").handler(this::handle).setName("System Properties").produces("application/json").produces("text/html").produces("text/plain");
    }

    public static void createAndDeploy(Router router) {
        DumpSysPropsRoute route = new DumpSysPropsRoute();
        route.standardDeploy(router);
    }

    public void handle(RoutingContext rc) {
        HttpServerRequest request = rc.request();
        if (request.method() == HttpMethod.GET) {
            List<Property> properties = DumpSysPropsRoute.getProperties();
            ContentTypes.adjustFromParams(rc);
            if ("application/json".equals(rc.getAcceptableContentType())) {
                HttpServerResponse response = rc.response();
                response.setStatusCode(200);
                response.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json");
                response.end(Json.encode(properties));
            } else if ("text/html".equals(rc.getAcceptableContentType())) {
                HttpServerResponse response = rc.response();
                response.setStatusCode(200);
                response.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"text/html");
                response.setChunked(true);
                response.write("<html>");
                response.write("<head>");
                response.write("</head>");
                response.write("<body>");
                response.write("<table>");
                response.write("<thead>");
                response.write("<tr>");
                response.write("<th>Name</th><th>Value</th>");
                response.write("</tr>");
                response.write("</thead>");
                response.write("<tbody>");
                for (Property prop : properties) {
                    response.write("<tr><td>");
                    response.write(prop.name);
                    response.write("</td><td>");
                    response.write(prop.value);
                    response.write("</td>");
                    response.write("</tr>");
                }
                response.write("</tbody>");
                response.write("</table>");
                response.write("</body>");
                response.write("</html>");
                response.end();
            } else {
                HttpServerResponse response = rc.response();
                response.setStatusCode(200);
                response.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"text/plain");
                response.setChunked(true);
                for (Property prop : properties) {
                    response.write(prop.name);
                    response.write(": ");
                    response.write(prop.value);
                    response.write("\n");
                }
                response.end();
            }
        }
    }

    static String toString(Object value) {
        if (value == null) {
            return "<null>";
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    static List<Property> getProperties() {
        return System.getProperties().entrySet().stream().map(entry -> new Property(DumpSysPropsRoute.toString(entry.getKey()), DumpSysPropsRoute.toString(entry.getValue()))).sorted((a, b) -> a.name.compareTo(b.name)).collect(Collectors.toList());
    }

    static class Property {
        private final String name;
        private final String value;

        Property(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @JsonProperty(value="name")
        String getName() {
            return this.name;
        }

        @JsonProperty(value="value")
        String getValue() {
            return this.value;
        }
    }
}

