/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.mgmt;

import com.sun.management.HotSpotDiagnosticMXBean;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.time.Clock;
import java.time.LocalDateTime;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.spudsoft.mgmt.ContentTypes;

public class HeapDumpRoute
implements Handler<RoutingContext> {
    private static final Logger logger = LoggerFactory.getLogger(HeapDumpRoute.class);
    public static final String PATH = "heapdump";

    public void standardDeploy(Router router) {
        router.route(HttpMethod.GET, "/heapdump").handler(this::handle).setName("Heap Dump").produces("application/octet-stream").produces("text/html");
    }

    public static void createAndDeploy(Router router) {
        HeapDumpRoute route = new HeapDumpRoute();
        route.standardDeploy(router);
    }

    public void handle(RoutingContext rc) {
        HttpServerResponse response = rc.response();
        HttpServerRequest request = rc.request();
        if (request.method() == HttpMethod.GET) {
            ContentTypes.adjustFromParams(rc);
            if ("text/html".equals(rc.getAcceptableContentType())) {
                response.setStatusCode(200);
                response.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"text/html");
                response.setChunked(true);
                response.write("<html>");
                response.write("<head>");
                response.write("</head>");
                response.write("<body>");
                response.write("<A target=\"_blank\" href=\"");
                response.write(request.path());
                response.write("?_fmt=binary\">Click to download heap dump file</A>");
                response.write("</body>");
                response.write("</html>");
                response.end();
            } else {
                File tempFile;
                String processName = HeapDumpRoute.getProcessName();
                String timestamp = LocalDateTime.now(Clock.systemUTC()).withNano(0).toString().replace(":", "-");
                String filename = processName + "-" + timestamp;
                try {
                    tempFile = File.createTempFile(filename, ".hprof");
                    tempFile.delete();
                }
                catch (IOException ex) {
                    HeapDumpRoute.reportError("Failed to create temporary file: ", ex, response);
                    return;
                }
                try {
                    HotSpotDiagnosticMXBean mxBean = ManagementFactory.getPlatformMXBean(HotSpotDiagnosticMXBean.class);
                    mxBean.dumpHeap(tempFile.getAbsolutePath(), false);
                }
                catch (Throwable ex) {
                    HeapDumpRoute.reportError("Failed to generate heap dump: ", ex, response);
                    return;
                }
                response.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/octet-stream");
                response.putHeader("Content-Disposition", "attachment; filename=\"" + filename + ".hprof\"");
                response.sendFile(tempFile.getAbsolutePath(), ar -> {
                    if (!tempFile.delete()) {
                        logger.error("Failed to delete temporary files: {}", (Object)tempFile);
                    } else {
                        logger.debug("Deleted temporary file: {}", (Object)tempFile);
                    }
                });
            }
        } else {
            rc.next();
        }
    }

    static void reportError(String message, Throwable ex, HttpServerResponse response) {
        logger.error(message, ex);
        response.setStatusCode(500);
        response.end("Failed to generate heap dump");
    }

    static String getProcessName() {
        return HeapDumpRoute.getProcessName(System.getProperty("sun.java.command"), () -> ProcessHandle.current());
    }

    static String getProcessName(String sunJavaCommand, Supplier<ProcessHandle> processHandleSupplier) {
        int idx;
        String processName = sunJavaCommand;
        int n = idx = processName == null ? 0 : processName.indexOf(" ");
        if (idx > 0) {
            processName = processName.substring(0, idx);
        }
        if (processName == null || processName.isEmpty()) {
            processName = processHandleSupplier.get().info().command().orElse("heap");
        }
        if ((idx = processName.lastIndexOf("/")) > 0) {
            processName = processName.substring(idx + 1);
        }
        if ((idx = processName.lastIndexOf("\\")) > 0) {
            processName = processName.substring(idx + 1);
        }
        if ((idx = processName.lastIndexOf(".jar")) > 0) {
            processName = processName.substring(0, idx);
        }
        return processName;
    }
}

