/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.mgmt;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InFlightRoute
implements Handler<RoutingContext> {
    public static final String PATH = "inflight";
    public static final String TIMESTAMP_KEY = InFlightRoute.class.getCanonicalName() + "_StartTimestamp";
    private static final Logger logger = LoggerFactory.getLogger(InFlightRoute.class);
    private final Map<SocketAddress, RoutingContext> map = new HashMap<SocketAddress, RoutingContext>();

    public void standardDeploy(Router rootRouter, Router manageRouter) {
        rootRouter.route().handler(this::record);
        manageRouter.route().handler(this::record);
        manageRouter.route(HttpMethod.GET, "/inflight").handler(this::handle).setName("In Flight").produces("application/json").produces("text/html").produces("text/plain");
    }

    public static void createAndDeploy(Router rootRouter, Router manageRouter) {
        InFlightRoute route = new InFlightRoute();
        route.standardDeploy(rootRouter, manageRouter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RoutingContext event) {
        JsonArray result = new JsonArray();
        Map<SocketAddress, RoutingContext> map = this.map;
        synchronized (map) {
            for (RoutingContext rc : this.map.values()) {
                try {
                    JsonObject data = new JsonObject();
                    Object timestampObject = rc.get(TIMESTAMP_KEY);
                    if (timestampObject instanceof Long) {
                        Long timestamp = (Long)timestampObject;
                        data.put("StartTimestamp", (Object)Instant.ofEpochMilli(timestamp).atOffset(ZoneOffset.UTC).toLocalDateTime().toString());
                        data.put("SecondsSoFar", (Object)((double)(System.currentTimeMillis() - timestamp) / 1000.0));
                    }
                    data.put("LocalAddress", (Object)Objects.toString(event.request().localAddress()));
                    data.put("RemoteAddress", (Object)Objects.toString(event.request().remoteAddress()));
                    data.put("AbsoluteUri", (Object)event.request().absoluteURI());
                    data.put("Query", (Object)event.request().query());
                    result.add((Object)data);
                }
                catch (Throwable ex) {
                    logger.warn("Failed to generate JSON for RoutingContext ({}): ", (Object)rc, (Object)ex);
                }
            }
        }
        event.end(result.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void record(RoutingContext event) {
        SocketAddress localAddress = event.request().localAddress();
        Map<SocketAddress, RoutingContext> map = this.map;
        synchronized (map) {
            event.put(TIMESTAMP_KEY, (Object)System.currentTimeMillis());
            this.map.put(localAddress, event);
        }
        event.addEndHandler(ar -> {
            Map<SocketAddress, RoutingContext> map = this.map;
            synchronized (map) {
                this.map.remove(localAddress);
            }
        });
        event.next();
    }
}

