/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.mgmt;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.ParsedHeaderValue;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.ParsableMIMEValue;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.spudsoft.mgmt.ContentTypes;

public class LogbackMgmtRoute
implements Handler<RoutingContext> {
    public static final String PATH = "logback";
    private static final Logger logger = LoggerFactory.getLogger(LogbackMgmtRoute.class);
    private static final ParsedHeaderValue HTML = new ParsableMIMEValue("text/html");
    private static final ParsedHeaderValue JSON = new ParsableMIMEValue("application/json");
    private String htmlContents;

    public void standardDeploy(Router router) {
        router.route(HttpMethod.GET, "/logback").handler(this::handle).setName("Logback Management").produces("application/json").produces("text/html").produces("text/plain");
        router.route(HttpMethod.PUT, "/logback/:logger").handler(this::handle).setName("Logback Management");
    }

    public static void createAndDeploy(Router router) {
        LogbackMgmtRoute route = new LogbackMgmtRoute();
        route.standardDeploy(router);
    }

    public void handle(RoutingContext rc) {
        HttpServerRequest request = rc.request();
        if (request.method() == HttpMethod.GET) {
            ContentTypes.adjustFromParams(rc);
            if ("application/json".equals(rc.getAcceptableContentType())) {
                this.getLogLevelsJson(rc.response());
            } else if ("text/html".equals(rc.getAcceptableContentType())) {
                this.getHtml(request, rc.response());
            } else {
                this.getLogLevelsText(rc.response());
            }
        } else if (request.method() == HttpMethod.PUT) {
            this.updateLogLevel(rc.pathParam("logger"), request, rc.response());
        } else {
            rc.next();
        }
    }

    public static JsonObject getLogLevels() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        JsonObject json = new JsonObject();
        JsonObject appenders = new JsonObject();
        json.put("appenders", (Object)appenders);
        JsonObject loggers = new JsonObject();
        json.put("loggers", (Object)loggers);
        for (ch.qos.logback.classic.Logger curLogger : loggerContext.getLoggerList()) {
            Iterator appenderIterator = curLogger.iteratorForAppenders();
            ArrayList<String> appendersForLogger = new ArrayList<String>();
            while (appenderIterator.hasNext()) {
                Appender appender = (Appender)appenderIterator.next();
                appendersForLogger.add(appender.getName());
                if (appenders.containsKey(appender.getName())) continue;
                JsonObject jsonAppender = new JsonObject();
                jsonAppender.put("name", (Object)appender.getName());
                jsonAppender.put("type", (Object)appender.getClass().toString());
                jsonAppender.put("started", (Object)appender.isStarted());
                appenders.put(appender.getName(), (Object)jsonAppender);
            }
            JsonObject jsonLogger = new JsonObject();
            jsonLogger.put("name", (Object)curLogger.getName());
            if (curLogger.getLevel() != null) {
                jsonLogger.put("level", (Object)curLogger.getLevel().levelStr);
            }
            if (curLogger.getEffectiveLevel() != null) {
                jsonLogger.put("effectiveLevel", (Object)curLogger.getEffectiveLevel().levelStr);
            }
            jsonLogger.put("additive", (Object)curLogger.isAdditive());
            jsonLogger.put("appenders", appendersForLogger);
            loggers.put(curLogger.getName(), (Object)jsonLogger);
        }
        return json;
    }

    public static void setLogLevel(String loggerName, String levelName) {
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger lg = null;
        if (loggerFactory instanceof LoggerContext) {
            LoggerContext lc = (LoggerContext)loggerFactory;
            lg = lc.exists(loggerName);
        }
        if (lg != null) {
            Level level = Level.toLevel((String)levelName);
            logger.info("Changing {} log level to {}", (Object)lg, (Object)level);
            lg.setLevel(level);
        } else {
            logger.info("Not changing the level of {} because it does not already exist", (Object)loggerName);
        }
    }

    private void getLogLevelsJson(HttpServerResponse response) {
        try {
            JsonObject json = LogbackMgmtRoute.getLogLevels();
            response.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json");
            response.setStatusCode(200);
            response.end(json.toBuffer());
        }
        catch (Throwable ex) {
            logger.error("Failed to get logback configuration: ", ex);
            response.setStatusCode(500);
            response.end();
        }
    }

    private void getLogLevelsText(HttpServerResponse response) {
        try {
            JsonObject json = LogbackMgmtRoute.getLogLevels();
            response.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"text/plain");
            response.setStatusCode(200);
            response.setChunked(true);
            response.write("appenders:");
            response.end();
        }
        catch (Throwable ex) {
            logger.error("Failed to get logback configuration: ", ex);
            response.setStatusCode(500);
            response.end();
        }
    }

    private void getHtml(HttpServerRequest request, HttpServerResponse response) {
        Future loadFuture = Future.succeededFuture((Object)this.htmlContents);
        if (loadFuture.result() == null) {
            loadFuture = Vertx.currentContext().executeBlocking(() -> {
                String string;
                block8: {
                    InputStream stream = this.getClass().getResourceAsStream("/logback.html");
                    try {
                        String newHtml;
                        this.htmlContents = newHtml = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                        string = newHtml;
                        if (stream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Throwable ex) {
                            logger.error("Failed to load HTML: ", ex);
                            this.getLogLevelsJson(response);
                            return null;
                        }
                    }
                    stream.close();
                }
                return string;
            });
        }
        loadFuture.map(html -> html.replaceAll("URL", "'" + request.absoluteURI() + "'")).compose(html -> {
            response.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"text/html");
            response.setStatusCode(200);
            response.end(html);
            return Future.succeededFuture();
        });
    }

    private void updateLogLevel(String loggerName, HttpServerRequest request, HttpServerResponse response) {
        request.body().compose(buffer -> {
            JsonObject jo = buffer.toJsonObject();
            String newLevel = jo.getString("level");
            LogbackMgmtRoute.setLogLevel(loggerName, newLevel);
            this.getLogLevelsJson(response);
            return Future.succeededFuture();
        });
    }
}

