/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.mgmt;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.CorsHandler;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.spudsoft.mgmt.AccessLogCaptureRoute;
import uk.co.spudsoft.mgmt.AccessLogOutputRoute;
import uk.co.spudsoft.mgmt.ContentTypes;
import uk.co.spudsoft.mgmt.DumpEnvRoute;
import uk.co.spudsoft.mgmt.DumpSysPropsRoute;
import uk.co.spudsoft.mgmt.HeapDumpRoute;
import uk.co.spudsoft.mgmt.InFlightRoute;
import uk.co.spudsoft.mgmt.LogbackMgmtRoute;
import uk.co.spudsoft.mgmt.ParametersRoute;
import uk.co.spudsoft.mgmt.ThreadDumpRoute;

public class ManagementRoute
implements Handler<RoutingContext> {
    public static final String PATH = "manage";
    private static final Logger logger = LoggerFactory.getLogger(ManagementRoute.class);
    private final Router mgmtRouter;
    private static final String HEAD = "<html><head><title>Management Endpoints</title><meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\"></head><body><table><tr><th>Route</th><th>Link</th></tr>";
    private static final String TAIL = "</table></body></html>";

    public ManagementRoute(Router mgmtRouter) {
        this.mgmtRouter = mgmtRouter;
    }

    public void standardDeploy(Router router) {
        router.route("/manage/*").subRouter(this.mgmtRouter);
        router.route(HttpMethod.GET, "/manage").handler(this::handle).setName("Management Routes").produces("application/json").produces("text/html").produces("text/plain");
    }

    public static Future<HttpServer> createAndDeploy(Vertx vertx, Router rootRouter, HttpServerOptions httperServerOptions, Integer mgmtPort, CorsHandler corsHandler, Router mgmtRouter, String mgmtEndpointUrl) {
        if (mgmtPort == null) {
            ManagementRoute route = new ManagementRoute(mgmtRouter);
            route.standardDeploy(rootRouter);
            return null;
        }
        if (mgmtPort > 0) {
            Router mgmtParentRouter = Router.router((Vertx)vertx);
            if (corsHandler != null) {
                mgmtParentRouter.route("/*").handler((Handler)corsHandler);
            }
            ManagementRoute route = new ManagementRoute(mgmtRouter);
            route.standardDeploy(mgmtParentRouter);
            HttpServerOptions options = new HttpServerOptions(httperServerOptions);
            options.setPort(mgmtPort.intValue());
            HttpServer mgmtHttpServer = vertx.createHttpServer(options);
            mgmtHttpServer.requestHandler((Handler)mgmtParentRouter);
            if (mgmtEndpointUrl != null && !mgmtEndpointUrl.isEmpty() && rootRouter != null) {
                rootRouter.get("/manage").handler(rc -> {
                    HttpServerResponse response = rc.response();
                    response.setStatusCode(200);
                    response.putHeader("Content-Type", "application/json");
                    JsonObject data = new JsonObject();
                    data.put("location", (Object)mgmtEndpointUrl);
                    rc.end(data.toBuffer());
                });
            }
            return mgmtHttpServer.listen(mgmtPort.intValue());
        }
        return null;
    }

    public static boolean mgmtEndpointPermitted(List<String> enabledEndpoints, String path) {
        if (enabledEndpoints.isEmpty()) {
            return true;
        }
        return enabledEndpoints.contains(path);
    }

    public static void deployStandardMgmtEndpoints(Router mgmtRouter, Router rootRouter, List<String> enabledEndpoints, AtomicReference<Object> params) {
        AccessLogCaptureRoute capture = null;
        if (ManagementRoute.mgmtEndpointPermitted(enabledEndpoints, "accesslog")) {
            capture = new AccessLogCaptureRoute(30);
            rootRouter.route("/*").handler((Handler)capture);
        }
        if (ManagementRoute.mgmtEndpointPermitted(enabledEndpoints, "heapdump")) {
            HeapDumpRoute.createAndDeploy(mgmtRouter);
        }
        if (ManagementRoute.mgmtEndpointPermitted(enabledEndpoints, "inflight")) {
            InFlightRoute.createAndDeploy(rootRouter, mgmtRouter);
        }
        if (ManagementRoute.mgmtEndpointPermitted(enabledEndpoints, "logback")) {
            LogbackMgmtRoute.createAndDeploy(mgmtRouter);
        }
        if (ManagementRoute.mgmtEndpointPermitted(enabledEndpoints, "threads")) {
            ThreadDumpRoute.createAndDeploy(mgmtRouter);
        }
        if (capture != null) {
            AccessLogOutputRoute.createAndDeploy(mgmtRouter, capture.getBuffer());
        }
        if (ManagementRoute.mgmtEndpointPermitted(enabledEndpoints, "envvars")) {
            DumpEnvRoute.createAndDeploy(mgmtRouter);
        }
        if (ManagementRoute.mgmtEndpointPermitted(enabledEndpoints, "sysprops")) {
            DumpSysPropsRoute.createAndDeploy(mgmtRouter);
        }
        if (ManagementRoute.mgmtEndpointPermitted(enabledEndpoints, "parameters") && params != null) {
            ParametersRoute.createAndDeploy(mgmtRouter, params);
        }
    }

    public void handle(RoutingContext rc) {
        HttpServerResponse response = rc.response();
        HttpServerRequest request = rc.request();
        if (request.method() == HttpMethod.GET) {
            ContentTypes.adjustFromParams(rc);
            if ("text/html".equals(rc.getAcceptableContentType())) {
                this.returnHtml(request, response);
            } else if ("application/json".equals(rc.getAcceptableContentType())) {
                this.returnJson(request, response);
            } else {
                this.returnText(request, response);
            }
        }
    }

    private void returnJson(HttpServerRequest request, HttpServerResponse response) {
        JsonArray result = new JsonArray();
        for (Route route : this.mgmtRouter.getRoutes()) {
            if (!route.isExactPath() || route.methods() == null || !route.methods().contains(HttpMethod.GET)) continue;
            JsonObject object = new JsonObject();
            object.put("name", (Object)route.getName());
            object.put("url", (Object)(request.absoluteURI() + route.getPath()));
            result.add((Object)object);
        }
        response.setStatusCode(200);
        response.putHeader("Content-Type", "application/json");
        response.end(result.toString());
    }

    private void returnText(HttpServerRequest request, HttpServerResponse response) {
        StringBuilder result = new StringBuilder();
        for (Route route : this.mgmtRouter.getRoutes()) {
            if (!route.isExactPath() || route.methods() == null || !route.methods().contains(HttpMethod.GET)) continue;
            result.append(route.getName()).append(": ").append(request.absoluteURI()).append(route.getPath());
        }
        response.setStatusCode(200);
        response.putHeader("Content-Type", "text/plain");
        response.end(result.toString());
    }

    private void returnHtml(HttpServerRequest request, HttpServerResponse response) {
        response.putHeader("Content-Type", "text/html");
        response.setChunked(true);
        response.write(HEAD);
        for (Route route : this.mgmtRouter.getRoutes()) {
            if (!route.isExactPath() || route.methods() == null || !route.methods().contains(HttpMethod.GET)) continue;
            response.write("<tr><td>" + route.getName() + "</td><td><a href=\"" + request.absoluteURI() + route.getPath() + "\">" + request.absoluteURI() + route.getPath() + "</td></tr>");
        }
        response.end(TAIL);
    }
}

