/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.mgmt;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.Json;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.util.concurrent.atomic.AtomicReference;
import uk.co.spudsoft.mgmt.ContentTypes;

public class ParametersRoute
implements Handler<RoutingContext> {
    public static final String PATH = "parameters";
    private final AtomicReference<Object> reference;

    public ParametersRoute(AtomicReference<Object> reference) {
        this.reference = reference;
    }

    public void standardDeploy(Router router) {
        router.route(HttpMethod.GET, "/parameters").handler(this::handle).setName("Parameters").produces("application/json").produces("text/html").produces("text/plain");
    }

    public static void createAndDeploy(Router router, AtomicReference<Object> reference) {
        ParametersRoute route = new ParametersRoute(reference);
        route.standardDeploy(router);
    }

    public void handle(RoutingContext rc) {
        HttpServerRequest request = rc.request();
        Object value = this.reference.get();
        if (request.method() == HttpMethod.GET) {
            ContentTypes.adjustFromParams(rc);
            if ("application/json".equals(rc.getAcceptableContentType())) {
                HttpServerResponse response = rc.response();
                response.setStatusCode(200);
                response.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json");
                response.end(Json.encode((Object)value));
            } else if ("text/html".equals(rc.getAcceptableContentType())) {
                HttpServerResponse response = rc.response();
                response.setStatusCode(200);
                response.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"text/html");
                response.setChunked(true);
                response.write("<html>");
                response.write("<head>");
                response.write("</head>");
                response.write("<body>");
                response.write("<pre>");
                response.write(Json.encodePrettily((Object)value));
                response.write("</pre>");
                response.write("</body>");
                response.write("</html>");
                response.end();
            } else {
                HttpServerResponse response = rc.response();
                response.setStatusCode(200);
                response.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"text/plain");
                response.end(Json.encodePrettily((Object)value));
            }
        } else {
            rc.next();
        }
    }
}

