/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.mgmt;

import java.util.function.IntFunction;

public class RingBuffer<T> {
    private final int capacity;
    private final Object[] array;
    private int insert = 0;
    private int size = 0;

    public RingBuffer(int capacity) {
        this.capacity = capacity;
        this.array = new Object[capacity + 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T item) {
        Object[] objectArray = this.array;
        synchronized (this.array) {
            this.array[this.insert] = item;
            ++this.insert;
            if (this.insert == this.capacity + 1) {
                this.insert = 0;
            }
            this.array[this.insert] = null;
            if (this.size < this.capacity) {
                ++this.size;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public int size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T[] toArray(IntFunction<T[]> generator) {
        T[] result = generator.apply(this.size);
        Object[] objectArray = this.array;
        synchronized (this.array) {
            int start = this.insert + 1;
            if (start == this.size + 1) {
                start = 0;
            }
            int i = start;
            int j = 0;
            while (this.array[i] != null) {
                result[j] = this.array[i];
                if (i == this.capacity) {
                    i = -1;
                }
                ++i;
                ++j;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }
}

