/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.mgmt;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import uk.co.spudsoft.mgmt.ContentTypes;
import uk.co.spudsoft.mgmt.HeapDumpRoute;

public class ThreadDumpRoute
implements Handler<RoutingContext> {
    public static final String PATH = "threads";

    public void standardDeploy(Router router) {
        router.route(HttpMethod.GET, "/threads").handler(this::handle).setName("Thread Dump").produces("application/json").produces("text/html").produces("text/plain");
    }

    public static void createAndDeploy(Router router) {
        ThreadDumpRoute route = new ThreadDumpRoute();
        route.standardDeploy(router);
    }

    public void handle(RoutingContext rc) {
        HttpServerRequest request = rc.request();
        if (request.method() == HttpMethod.GET) {
            ContentTypes.adjustFromParams(rc);
            if ("application/json".equals(rc.getAcceptableContentType())) {
                HttpServerResponse response = rc.response();
                response.setStatusCode(200);
                response.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json");
                response.end(ThreadDumpRoute.buildStackTraceJson().toBuffer());
            } else if ("text/html".equals(rc.getAcceptableContentType())) {
                HttpServerResponse response = rc.response();
                response.setStatusCode(200);
                response.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"text/html");
                response.end(ThreadDumpRoute.buildStackTraceHtml());
            } else {
                HttpServerResponse response = rc.response();
                response.setStatusCode(200);
                response.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"text/plain");
                response.end(ThreadDumpRoute.buildStackTraceText());
            }
        } else {
            rc.next();
        }
    }

    static String buildStackTraceHtml() {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfo = threadMxBean.dumpAllThreads(true, true);
        StringBuilder stackTraceString = new StringBuilder();
        stackTraceString.append("<html><head>");
        stackTraceString.append("<title>").append(HeapDumpRoute.getProcessName()).append(" @ ").append(ZonedDateTime.now(ZoneOffset.UTC).toString()).append("</title>");
        stackTraceString.append("</head><body>");
        stackTraceString.append("<table>");
        for (ThreadInfo t : threadInfo) {
            stackTraceString.append("<tr>");
            stackTraceString.append("<td><b>");
            stackTraceString.append(t.getThreadName());
            stackTraceString.append("</b></td>");
            stackTraceString.append("<td>");
            stackTraceString.append(t.getThreadId());
            stackTraceString.append("</td>");
            stackTraceString.append("<td>");
            stackTraceString.append((Object)t.getThreadState());
            stackTraceString.append("</td>");
            stackTraceString.append("<td>");
            stackTraceString.append(t.isDaemon() ? "daemon" : "");
            stackTraceString.append("</td>");
            stackTraceString.append("<td>");
            stackTraceString.append(t.isSuspended() ? "suspended" : "");
            stackTraceString.append("</td>");
            stackTraceString.append("<td>");
            stackTraceString.append("</td>");
            stackTraceString.append("</tr>");
            String lockName = t.getLockName();
            if (lockName != null) {
                stackTraceString.append("<tr><td colspan=\"6\" style=\"padding-left: 20px;\">Waiting for ").append(lockName);
                if (t.getLockOwnerId() >= 0L) {
                    stackTraceString.append("<br/>Held by ").append(t.getLockOwnerId()).append(" (").append(t.getLockOwnerName()).append(")");
                }
                stackTraceString.append("</td></tr>");
            }
            stackTraceString.append("<tr><td colspan=\"6\" style=\"padding-left: 40px;\"><pre>");
            for (StackTraceElement s : t.getStackTrace()) {
                stackTraceString.append(s.toString()).append("\n");
            }
            stackTraceString.append("</pre></td></tr>\n");
        }
        stackTraceString.append("</table><body></html>");
        return stackTraceString.toString();
    }

    static JsonObject buildStackTraceJson() {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfo = threadMxBean.dumpAllThreads(true, true);
        JsonObject result = new JsonObject();
        for (ThreadInfo t : threadInfo) {
            JsonObject thread = new JsonObject();
            result.put(t.getThreadName(), (Object)thread);
            thread.put("id", (Object)t.getThreadId());
            thread.put("daemon", (Object)t.isDaemon());
            thread.put("suspended", (Object)t.isSuspended());
            thread.put("state", (Object)t.getThreadState());
            ThreadDumpRoute.addNonNullObjectToJson(thread, "lockInfo", t.getLockInfo());
            ThreadDumpRoute.addNonNullObjectToJson(thread, "lockOwnerName", t.getLockOwnerName());
            long lockOwnerId = t.getLockOwnerId();
            if (lockOwnerId > 0L) {
                thread.put("lockOwnerId", (Object)lockOwnerId);
            }
            thread.put("blockedCount", (Object)t.getBlockedCount());
            thread.put("blockedTime", (Object)t.getBlockedTime());
            StackTraceElement[] stackTrace = t.getStackTrace();
            JsonArray jsonStack = new JsonArray();
            thread.put("stackTrace", (Object)jsonStack);
            for (StackTraceElement s : stackTrace) {
                JsonObject stackTraceElement = new JsonObject();
                ThreadDumpRoute.addNonNullObjectToJson(stackTraceElement, "classLoaderName", s.getClassLoaderName());
                ThreadDumpRoute.addNonNullObjectToJson(stackTraceElement, "className", s.getClassName());
                ThreadDumpRoute.addNonNullObjectToJson(stackTraceElement, "fileName", s.getFileName());
                ThreadDumpRoute.addNonNullObjectToJson(stackTraceElement, "lineNumber", s.getLineNumber());
                ThreadDumpRoute.addNonNullObjectToJson(stackTraceElement, "methodName", s.getMethodName());
                ThreadDumpRoute.addNonNullObjectToJson(stackTraceElement, "moduleName", s.getModuleName());
                ThreadDumpRoute.addNonNullObjectToJson(stackTraceElement, "moduleVersion", s.getModuleVersion());
                jsonStack.add((Object)stackTraceElement);
            }
        }
        return result;
    }

    static void addNonNullObjectToJson(JsonObject parent, String name, Object value) {
        if (name != null) {
            parent.put(name, value);
        }
    }

    static String buildStackTraceText() {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfo = threadMxBean.dumpAllThreads(true, true);
        StringBuilder stackTraceString = new StringBuilder();
        for (ThreadInfo t : threadInfo) {
            String lockName;
            StackTraceElement[] stackTrace = t.getStackTrace();
            stackTraceString.append(t.getThreadName()).append(" (").append((Object)t.getThreadState()).append(")").append(t.isDaemon() ? " Daemon" : "").append("\n");
            if (t.isSuspended()) {
                stackTraceString.append("Suspended\n");
            }
            if ((lockName = t.getLockName()) != null) {
                stackTraceString.append("Waiting for ").append(lockName);
                if (t.getLockOwnerId() >= 0L) {
                    stackTraceString.append(" held by ").append(t.getLockOwnerId()).append(" (").append(t.getLockOwnerName()).append(")");
                }
                stackTraceString.append("\n");
            }
            for (StackTraceElement s : stackTrace) {
                stackTraceString.append("  ").append(s.toString()).append("\n");
            }
            stackTraceString.append("\n");
        }
        return stackTraceString.toString();
    }
}

