/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.di.ipv.cri.common.library.domain.personidentity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.util.Objects;
import uk.gov.di.ipv.cri.common.library.domain.personidentity.AddressType;
import uk.gov.di.ipv.cri.common.library.persistence.item.CanonicalAddress;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Address {
    private Long uprn;
    private String organisationName;
    private String departmentName;
    private String subBuildingName;
    private String buildingNumber;
    private String buildingName;
    private String dependentStreetName;
    private String streetName;
    private String doubleDependentAddressLocality;
    private String dependentAddressLocality;
    private String addressLocality;
    private String postalCode;
    private String addressCountry;
    private String addressRegion;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private LocalDate validFrom;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private LocalDate validUntil;

    public Address() {
        this(new CanonicalAddress());
    }

    public Address(CanonicalAddress address) {
        this.uprn = address.getUprn();
        this.organisationName = address.getOrganisationName();
        this.departmentName = address.getDepartmentName();
        this.subBuildingName = address.getSubBuildingName();
        this.buildingNumber = address.getBuildingNumber();
        this.buildingName = address.getBuildingName();
        this.dependentStreetName = address.getDependentStreetName();
        this.streetName = address.getStreetName();
        this.doubleDependentAddressLocality = address.getDoubleDependentAddressLocality();
        this.dependentAddressLocality = address.getDependentAddressLocality();
        this.addressLocality = address.getAddressLocality();
        this.postalCode = address.getPostalCode();
        this.addressCountry = address.getAddressCountry();
        this.addressRegion = address.getAddressRegion();
        this.validFrom = address.getValidFrom();
        this.validUntil = address.getValidUntil();
    }

    public Long getUprn() {
        return this.uprn;
    }

    public void setUprn(Long uprn) {
        this.uprn = uprn;
    }

    public String getOrganisationName() {
        return this.organisationName;
    }

    public void setOrganisationName(String organisationName) {
        this.organisationName = organisationName;
    }

    public String getDepartmentName() {
        return this.departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getSubBuildingName() {
        return this.subBuildingName;
    }

    public void setSubBuildingName(String subBuildingName) {
        this.subBuildingName = subBuildingName;
    }

    public String getBuildingNumber() {
        return this.buildingNumber;
    }

    public void setBuildingNumber(String buildingNumber) {
        this.buildingNumber = buildingNumber;
    }

    public String getDependentStreetName() {
        return this.dependentStreetName;
    }

    public void setDependentStreetName(String dependentStreetName) {
        this.dependentStreetName = dependentStreetName;
    }

    public String getDoubleDependentAddressLocality() {
        return this.doubleDependentAddressLocality;
    }

    public void setDoubleDependentAddressLocality(String doubleDependentAddressLocality) {
        this.doubleDependentAddressLocality = doubleDependentAddressLocality;
    }

    public String getDependentAddressLocality() {
        return this.dependentAddressLocality;
    }

    public void setDependentAddressLocality(String dependentAddressLocality) {
        this.dependentAddressLocality = dependentAddressLocality;
    }

    public String getBuildingName() {
        return this.buildingName;
    }

    public void setBuildingName(String buildingName) {
        this.buildingName = buildingName;
    }

    public String getStreetName() {
        return this.streetName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }

    public String getAddressLocality() {
        return this.addressLocality;
    }

    public void setAddressLocality(String addressLocality) {
        this.addressLocality = addressLocality;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getAddressCountry() {
        return this.addressCountry;
    }

    public void setAddressCountry(String addressCountry) {
        this.addressCountry = addressCountry;
    }

    public String getAddressRegion() {
        return this.addressRegion;
    }

    public void setAddressRegion(String addressRegion) {
        this.addressRegion = addressRegion;
    }

    public LocalDate getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(LocalDate validFrom) {
        this.validFrom = validFrom;
    }

    public LocalDate getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(LocalDate validUntil) {
        this.validUntil = validUntil;
    }

    @JsonIgnore
    public AddressType getAddressType() {
        boolean validFromIsSpecified = Objects.nonNull(this.getValidFrom());
        boolean validUntilIsSpecified = Objects.nonNull(this.getValidUntil());
        if (!(validUntilIsSpecified || validFromIsSpecified && !this.isPastDateOrToday(this.getValidFrom()))) {
            return AddressType.CURRENT;
        }
        if (validUntilIsSpecified && this.isPastDateOrToday(this.getValidUntil()) && (!validFromIsSpecified || this.isPastDate(this.getValidFrom()) && this.getValidUntil().isAfter(this.getValidFrom()))) {
            return AddressType.PREVIOUS;
        }
        return null;
    }

    private ChronoLocalDate getDateToday() {
        return ChronoLocalDate.from(ZonedDateTime.now());
    }

    private boolean isPastDate(LocalDate input) {
        return input.compareTo(this.getDateToday()) < 0;
    }

    private boolean isPastDateOrToday(LocalDate input) {
        return input.compareTo(this.getDateToday()) <= 0;
    }
}

