/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.di.ipv.cri.common.library.persistence;

import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClient;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbIndex;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbTable;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.model.BatchWriteItemEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.BatchWriteResult;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.WriteBatch;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbException;
import uk.gov.di.ipv.cri.common.library.util.ClientProviderFactory;

public class DataStore<T> {
    private final DynamoDbTable<T> table;
    private final Class<T> typeParameterClass;
    private final DynamoDbEnhancedClient dynamoDbEnhancedClient;

    public DataStore(String tableName, Class<T> typeParameterClass, DynamoDbEnhancedClient dynamoDbEnhancedClient) {
        this.table = dynamoDbEnhancedClient.table(tableName, (TableSchema)TableSchema.fromBean(typeParameterClass));
        this.typeParameterClass = typeParameterClass;
        this.dynamoDbEnhancedClient = dynamoDbEnhancedClient;
    }

    @Deprecated(forRemoval=true)
    public static DynamoDbEnhancedClient getClient() {
        ClientProviderFactory clientProviderFactory = new ClientProviderFactory();
        return clientProviderFactory.getDynamoDbEnhancedClient();
    }

    public void create(T item) {
        this.table.putItem(item);
    }

    public void createItems(List<T> items) {
        WriteBatch putItemsBatch = this.createPutItemsWriteBatch(items);
        BatchWriteResult batchWriteResult = this.persistBatch(putItemsBatch);
        List unprocessedItems = batchWriteResult.unprocessedPutItemsForTable(this.table);
        do {
            if (unprocessedItems.isEmpty()) continue;
            batchWriteResult = this.persistBatch(this.createPutItemsWriteBatch(unprocessedItems));
            unprocessedItems = batchWriteResult.unprocessedPutItemsForTable(this.table);
        } while (!unprocessedItems.isEmpty());
    }

    public T getItem(String partitionValue, String sortValue) {
        return this.getItemByKey(Key.builder().partitionValue(partitionValue).sortValue(sortValue).build());
    }

    public T getItem(String partitionValue) {
        return this.getItemByKey(Key.builder().partitionValue(partitionValue).build());
    }

    public List<T> getItems(String partitionValue) {
        return this.table.query(QueryConditional.keyEqualTo((Key)Key.builder().partitionValue(partitionValue).build())).stream().flatMap(page -> page.items().stream()).collect(Collectors.toList());
    }

    public List<T> getItemByIndex(String indexName, String value) throws DynamoDbException {
        DynamoDbIndex index = this.table.index(indexName);
        AttributeValue attVal = (AttributeValue)AttributeValue.builder().s(value).build();
        QueryConditional queryConditional = QueryConditional.keyEqualTo((Key)Key.builder().partitionValue(attVal).build());
        QueryEnhancedRequest queryEnhancedRequest = QueryEnhancedRequest.builder().queryConditional(queryConditional).build();
        return index.query(queryEnhancedRequest).stream().flatMap(page -> page.items().stream()).collect(Collectors.toList());
    }

    public List<T> getItemsByAttribute(String attributeName, String attributeValue) {
        AttributeValue expressionValue = (AttributeValue)AttributeValue.builder().s(attributeValue).build();
        Expression attributeFilterExpression = Expression.builder().expression("#a = :b").putExpressionName("#a", attributeName).putExpressionValue(":b", expressionValue).build();
        return this.table.scan(r -> r.filterExpression(attributeFilterExpression)).stream().flatMap(page -> page.items().stream()).collect(Collectors.toList());
    }

    public T update(T item) {
        return (T)this.table.updateItem(item);
    }

    public T delete(String partitionValue, String sortValue) {
        return this.delete(Key.builder().partitionValue(partitionValue).sortValue(sortValue).build());
    }

    public T delete(String partitionValue) {
        return this.delete(Key.builder().partitionValue(partitionValue).build());
    }

    private T getItemByKey(Key key) {
        return (T)this.table.getItem(key);
    }

    private T delete(Key key) {
        return (T)this.table.deleteItem(key);
    }

    private WriteBatch createPutItemsWriteBatch(List<T> items) {
        WriteBatch.Builder builder = WriteBatch.builder(this.typeParameterClass).mappedTableResource(this.table);
        for (Object item : items) {
            builder.addPutItem(r -> r.item(item).build());
        }
        return builder.build();
    }

    private BatchWriteResult persistBatch(WriteBatch writeBatch) {
        return this.dynamoDbEnhancedClient.batchWriteItem(BatchWriteItemEnhancedRequest.builder().writeBatches(new WriteBatch[]{writeBatch}).build());
    }
}

