/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.di.ipv.cri.common.library.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.utils.StringUtils;
import uk.gov.di.ipv.cri.common.library.domain.AuditEvent;
import uk.gov.di.ipv.cri.common.library.domain.AuditEventContext;
import uk.gov.di.ipv.cri.common.library.domain.AuditEventType;
import uk.gov.di.ipv.cri.common.library.exception.SqsException;
import uk.gov.di.ipv.cri.common.library.service.AuditEventFactory;
import uk.gov.di.ipv.cri.common.library.service.ConfigurationService;

public class AuditService {
    private final SqsClient sqs;
    private final String queueUrl;
    private final ObjectMapper objectMapper;
    private final AuditEventFactory auditEventFactory;

    public AuditService(SqsClient sqs, ConfigurationService configurationService, ObjectMapper objectMapper, AuditEventFactory auditEventFactory) {
        this.sqs = sqs;
        this.objectMapper = objectMapper.registerModule((Module)new JavaTimeModule());
        this.auditEventFactory = auditEventFactory;
        this.queueUrl = configurationService.getSqsAuditEventQueueUrl();
        this.requireNonBlankQueueUrl();
    }

    private void requireNonBlankQueueUrl() {
        if (StringUtils.isBlank((CharSequence)this.queueUrl)) {
            throw new IllegalStateException("Null or empty queue url provided by configuration service");
        }
    }

    public void sendAuditEvent(AuditEventType eventType) throws SqsException {
        this.sendAuditEvent(eventType.toString(), null, null);
    }

    public void sendAuditEvent(String eventType) throws SqsException {
        this.sendAuditEvent(eventType, null, null);
    }

    public void sendAuditEvent(AuditEventType eventType, AuditEventContext context) throws SqsException {
        this.sendAuditEvent(eventType.toString(), context, null);
    }

    public void sendAuditEvent(String eventType, AuditEventContext context) throws SqsException {
        AuditEvent<Object> auditEvent = this.auditEventFactory.create(eventType, context, null);
        this.sendAuditEvent(auditEvent);
    }

    public <T> void sendAuditEvent(AuditEventType eventType, AuditEventContext context, T extensions) throws SqsException {
        this.sendAuditEvent(eventType.toString(), context, extensions);
    }

    public <T> void sendAuditEvent(String eventType, AuditEventContext context, T extensions) throws SqsException {
        AuditEvent<T> audiEvent = this.auditEventFactory.create(eventType, context, extensions);
        this.sendAuditEvent(audiEvent);
    }

    public <T> void sendAuditEvent(AuditEventType eventType, T extensions) throws SqsException {
        this.sendAuditEvent(eventType.toString(), extensions);
    }

    public <T> void sendAuditEvent(String eventType, T extensions) throws SqsException {
        AuditEvent<T> audiEvent = this.auditEventFactory.create(eventType, null, extensions);
        this.sendAuditEvent(audiEvent);
    }

    private <T> void sendAuditEvent(AuditEvent<T> auditEvent) throws SqsException {
        try {
            String serialisedAuditEvent = this.objectMapper.writeValueAsString(auditEvent);
            SendMessageRequest sendMessageRequest = (SendMessageRequest)SendMessageRequest.builder().queueUrl(this.queueUrl).messageBody(serialisedAuditEvent).build();
            this.sqs.sendMessage(sendMessageRequest);
        }
        catch (JsonProcessingException e) {
            throw new SqsException(e);
        }
    }
}

