/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.di.ipv.cri.common.library.service;

import java.util.List;
import uk.gov.di.ipv.cri.common.library.domain.personidentity.Address;
import uk.gov.di.ipv.cri.common.library.domain.personidentity.BirthDate;
import uk.gov.di.ipv.cri.common.library.domain.personidentity.DrivingPermit;
import uk.gov.di.ipv.cri.common.library.domain.personidentity.Name;
import uk.gov.di.ipv.cri.common.library.domain.personidentity.Passport;
import uk.gov.di.ipv.cri.common.library.domain.personidentity.PersonIdentityDetailed;
import uk.gov.di.ipv.cri.common.library.domain.personidentity.SocialSecurityRecord;

public class PersonIdentityDetailedBuilder {
    private PersonIdentityDetailedBuilder() {
        throw new IllegalStateException("Instantiation is not valid for this class.");
    }

    public static Builder builder(List<Name> names, List<BirthDate> birthDates) {
        return new Builder(names, birthDates);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<SocialSecurityRecord> socialSecurityRecords;
        private List<Name> names;
        private List<BirthDate> birthDates;
        private List<Address> addresses;
        private List<DrivingPermit> drivingPermits;
        private List<Passport> passports;

        private Builder() {
            this(null, null);
        }

        private Builder(List<Name> names, List<BirthDate> birthDates) {
            this.names = names;
            this.birthDates = birthDates;
        }

        public Builder withAddresses(List<Address> addresses) {
            this.addresses = addresses;
            return this;
        }

        public Builder withDrivingPermits(List<DrivingPermit> drivingPermits) {
            this.drivingPermits = drivingPermits;
            return this;
        }

        public Builder withPassports(List<Passport> passports) {
            this.passports = passports;
            return this;
        }

        public Builder withNino(List<SocialSecurityRecord> socialSecurityRecords) {
            this.socialSecurityRecords = socialSecurityRecords;
            return this;
        }

        public PersonIdentityDetailed build() {
            return new PersonIdentityDetailed(this.names, this.birthDates, this.addresses, this.drivingPermits, this.passports, this.socialSecurityRecords);
        }
    }
}

