/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.di.ipv.cri.common.library.service;

import java.util.UUID;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClient;
import uk.gov.di.ipv.cri.common.library.annotations.ExcludeFromGeneratedCoverageReport;
import uk.gov.di.ipv.cri.common.library.domain.personidentity.PersonIdentity;
import uk.gov.di.ipv.cri.common.library.domain.personidentity.PersonIdentityDetailed;
import uk.gov.di.ipv.cri.common.library.domain.personidentity.SharedClaims;
import uk.gov.di.ipv.cri.common.library.persistence.DataStore;
import uk.gov.di.ipv.cri.common.library.persistence.item.personidentity.PersonIdentityItem;
import uk.gov.di.ipv.cri.common.library.service.ConfigurationService;
import uk.gov.di.ipv.cri.common.library.service.PersonIdentityMapper;

public class PersonIdentityService {
    private static final String PERSON_IDENTITY_TABLE_PARAM_NAME = "PersonIdentityTableName";
    private final PersonIdentityMapper personIdentityMapper;
    private final ConfigurationService configurationService;
    private final DataStore<PersonIdentityItem> personIdentityDataStore;

    @ExcludeFromGeneratedCoverageReport
    public PersonIdentityService(ConfigurationService configurationService, DynamoDbEnhancedClient dynamoDbEnhancedClient) {
        this(new PersonIdentityMapper(), configurationService, new DataStore<PersonIdentityItem>(configurationService.getCommonParameterValue(PERSON_IDENTITY_TABLE_PARAM_NAME), PersonIdentityItem.class, dynamoDbEnhancedClient));
    }

    public PersonIdentityService(PersonIdentityMapper personIdentityMapper, ConfigurationService configurationService, DataStore<PersonIdentityItem> personIdentityDataStore) {
        this.personIdentityMapper = personIdentityMapper;
        this.configurationService = configurationService;
        this.personIdentityDataStore = personIdentityDataStore;
    }

    public void savePersonIdentity(UUID sessionId, SharedClaims sharedClaims) {
        PersonIdentityItem personIdentityItem = this.personIdentityMapper.mapToPersonIdentityItem(sharedClaims);
        personIdentityItem.setSessionId(sessionId);
        personIdentityItem.setExpiryDate(this.configurationService.getSessionExpirationEpoch());
        this.personIdentityDataStore.create(personIdentityItem);
    }

    public PersonIdentity getPersonIdentity(UUID sessionId) {
        PersonIdentityItem personIdentityItem = this.getById(sessionId);
        return this.personIdentityMapper.mapToPersonIdentity(personIdentityItem);
    }

    public PersonIdentityDetailed getPersonIdentityDetailed(UUID sessionId) {
        PersonIdentityItem personIdentityItem = this.getById(sessionId);
        return this.personIdentityMapper.mapToPersonIdentityDetailed(personIdentityItem);
    }

    public PersonIdentity convertToPersonIdentitySummary(PersonIdentityDetailed personIdentityDetailed) {
        return this.personIdentityMapper.mapToPersonIdentity(personIdentityDetailed);
    }

    private PersonIdentityItem getById(UUID sessionId) {
        return this.personIdentityDataStore.getItem(String.valueOf(sessionId));
    }
}

