/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.di.ipv.cri.common.library.service;

import com.nimbusds.oauth2.sdk.token.AccessToken;
import java.time.Clock;
import java.util.Optional;
import java.util.UUID;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClient;
import software.amazon.lambda.powertools.logging.LoggingUtils;
import uk.gov.di.ipv.cri.common.library.annotations.ExcludeFromGeneratedCoverageReport;
import uk.gov.di.ipv.cri.common.library.domain.SessionRequest;
import uk.gov.di.ipv.cri.common.library.exception.AccessTokenExpiredException;
import uk.gov.di.ipv.cri.common.library.exception.AuthorizationCodeExpiredException;
import uk.gov.di.ipv.cri.common.library.exception.SessionExpiredException;
import uk.gov.di.ipv.cri.common.library.exception.SessionNotFoundException;
import uk.gov.di.ipv.cri.common.library.persistence.DataStore;
import uk.gov.di.ipv.cri.common.library.persistence.item.SessionItem;
import uk.gov.di.ipv.cri.common.library.service.ConfigurationService;
import uk.gov.di.ipv.cri.common.library.util.ListUtil;
import uk.gov.di.ipv.cri.common.library.util.retry.RetryConfig;
import uk.gov.di.ipv.cri.common.library.util.retry.RetryManager;
import uk.gov.di.ipv.cri.common.library.util.retry.Retryable;

public class SessionService {
    private static final String SESSION_TABLE_PARAM_NAME = "SessionTableName";
    private static final String GOVUK_SIGNIN_JOURNEY_ID = "govuk_signin_journey_id";
    private static final String REQUESTED_VERIFICATION_SCORE = "requested_verification_score";
    private final ConfigurationService configurationService;
    private final DataStore<SessionItem> dataStore;
    private final Clock clock;

    @ExcludeFromGeneratedCoverageReport
    public SessionService(ConfigurationService configurationService, DynamoDbEnhancedClient dynamoDbEnhancedClient) {
        this(new DataStore<SessionItem>(configurationService.getCommonParameterValue(SESSION_TABLE_PARAM_NAME), SessionItem.class, dynamoDbEnhancedClient), configurationService, Clock.systemUTC());
    }

    public SessionService(DataStore<SessionItem> dataStore, ConfigurationService configurationService, Clock clock) {
        this.dataStore = dataStore;
        this.configurationService = configurationService;
        this.clock = clock;
    }

    public UUID saveSession(SessionRequest sessionRequest) {
        SessionItem sessionItem = new SessionItem();
        sessionItem.setCreatedDate(this.clock.instant().getEpochSecond());
        sessionItem.setExpiryDate(this.configurationService.getSessionExpirationEpoch());
        sessionItem.setState(sessionRequest.getState());
        sessionItem.setClientId(sessionRequest.getClientId());
        sessionItem.setEvidenceRequest(sessionRequest.getEvidenceRequest());
        sessionItem.setRedirectUri(sessionRequest.getRedirectUri());
        sessionItem.setSubject(sessionRequest.getSubject());
        sessionItem.setPersistentSessionId(sessionRequest.getPersistentSessionId());
        sessionItem.setClientSessionId(sessionRequest.getClientSessionId());
        sessionItem.setClientIpAddress(sessionRequest.getClientIpAddress());
        sessionItem.setAttemptCount(0);
        sessionItem.setContext(sessionRequest.getContext());
        this.setSessionItemsToLogging(sessionItem);
        this.dataStore.create(sessionItem);
        return sessionItem.getSessionId();
    }

    public void updateSession(SessionItem sessionItem) {
        this.setSessionItemsToLogging(sessionItem);
        this.dataStore.update(sessionItem);
    }

    public void createAuthorizationCode(SessionItem session) {
        session.setAuthorizationCode(UUID.randomUUID().toString());
        session.setAuthorizationCodeExpiryDate(this.configurationService.getAuthorizationCodeExpirationEpoch());
        this.updateSession(session);
    }

    public SessionItem validateSessionId(String sessionId) throws SessionNotFoundException, SessionExpiredException {
        if (sessionId == null || sessionId.isBlank()) {
            throw new SessionNotFoundException("session id empty");
        }
        SessionItem sessionItem = this.dataStore.getItem(sessionId);
        this.setSessionItemsToLogging(sessionItem);
        if (sessionItem == null) {
            throw new SessionNotFoundException("session not found");
        }
        if (sessionItem.getExpiryDate() < this.clock.instant().getEpochSecond()) {
            throw new SessionExpiredException("session expired");
        }
        return sessionItem;
    }

    private void setSessionItemsToLogging(SessionItem sessionItem) {
        Optional.ofNullable(sessionItem).ifPresent(s -> {
            Optional.ofNullable(s.getClientSessionId()).ifPresent(id -> LoggingUtils.appendKey((String)GOVUK_SIGNIN_JOURNEY_ID, (String)id));
            Optional.ofNullable(s.getEvidenceRequest()).flatMap(ev -> Optional.ofNullable(ev.getVerificationScore())).ifPresent(verificationScore -> LoggingUtils.appendKey((String)REQUESTED_VERIFICATION_SCORE, (String)String.valueOf(verificationScore)));
        });
    }

    public SessionItem getSession(String sessionId) {
        SessionItem sessionItem = this.dataStore.getItem(sessionId);
        this.setSessionItemsToLogging(sessionItem);
        return sessionItem;
    }

    public SessionItem getSessionByAccessToken(AccessToken accessToken) throws SessionExpiredException, AccessTokenExpiredException, SessionNotFoundException {
        RetryConfig retryConfig = this.getRetryConfig(500, 3, true);
        Retryable<SessionItem> retryable = () -> this.getSessionByGsiIndex("access-token-index", accessToken.toAuthorizationHeader(), "access token");
        SessionItem sessionItem = RetryManager.execute(retryConfig, retryable);
        if ((sessionItem = this.validateSessionId(String.valueOf(sessionItem.getSessionId()))).getAccessTokenExpiryDate() < this.clock.instant().getEpochSecond()) {
            throw new AccessTokenExpiredException("access code expired");
        }
        return sessionItem;
    }

    public SessionItem getSessionByAuthorisationCode(String authCode) throws SessionExpiredException, AuthorizationCodeExpiredException, SessionNotFoundException {
        RetryConfig retryConfig = this.getRetryConfig(500, 3, true);
        Retryable<SessionItem> retryable = () -> this.getSessionByGsiIndex("authorizationCode-index", authCode, "authorization code");
        SessionItem sessionItem = RetryManager.execute(retryConfig, retryable);
        if ((sessionItem = this.validateSessionId(String.valueOf(sessionItem.getSessionId()))).getAuthorizationCodeExpiryDate() < this.clock.instant().getEpochSecond()) {
            throw new AuthorizationCodeExpiredException("authorization code expired");
        }
        return sessionItem;
    }

    private RetryConfig getRetryConfig(int delayMs, int maxAttempts, boolean exponential) {
        return new RetryConfig.Builder().delayBetweenAttempts(delayMs).maxAttempts(maxAttempts).exponentiallyRetry(exponential).build();
    }

    private SessionItem getSessionByGsiIndex(String indexName, String indexValue, String indexNameLabel) {
        try {
            return ListUtil.getOneItemOrThrowError(this.dataStore.getItemByIndex(indexName, indexValue));
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().contains("No items found")) {
                throw new SessionNotFoundException(String.format("no session found with that %s", indexNameLabel));
            }
            throw new SessionNotFoundException(String.format("more than one session found with that %s", indexNameLabel));
        }
    }
}

