/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.di.ipv.cri.common.library.util;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkTelemetry;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ContainerCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.awscore.defaultsmode.DefaultsMode;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClient;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.crt.AwsCrtHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.acm.AcmClient;
import software.amazon.awssdk.services.acm.AcmClientBuilder;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.KmsClientBuilder;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.SsmClientBuilder;
import software.amazon.lambda.powertools.parameters.ParamManager;
import software.amazon.lambda.powertools.parameters.SSMProvider;
import software.amazon.lambda.powertools.parameters.SecretsProvider;

public class ClientProviderFactory {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String CONFIG_SERVICE_SSM_OPTIMIZED_CACHE_AGE_MIN_MINUTES = "CONFIG_SERVICE_SSM_OPTIMIZED_CACHE_AGE_MIN_MINUTES";
    public static final String CONFIG_SERVICE_SSM_OPTIMIZED_CACHE_AGE_MAX_MINUTES = "CONFIG_SERVICE_SSM_OPTIMIZED_CACHE_AGE_MAX_MINUTES";
    private final SdkHttpClient sdkHttpClient;
    private final Region awsRegion;
    private final AwsCredentialsProvider awsCredentialsProvider;
    private static final DefaultsMode DEFAULTS_MODE = DefaultsMode.IN_REGION;
    private KmsClient kmsClient;
    private SqsClient sqsClient;
    private DynamoDbEnhancedClient dynamoDbEnhancedClient;
    private SsmClient ssmClient;
    private SSMProvider ssmProvider;
    private SecretsProvider secretsProvider;
    private SecretsManagerClient secretsManagerClient;
    private AcmClient acmClient;
    private final boolean addOpenTelemetryExecutionInterceptors;
    private final boolean avoidExecutionInterceptorsOnClientsUsedByPowerTools;

    public ClientProviderFactory() {
        this(false, false);
    }

    public ClientProviderFactory(boolean usingNonAutomaticOpenTelemetry, boolean avoidExecutionInterceptorsOnClientsUsedByPowerTools) {
        this.addOpenTelemetryExecutionInterceptors = usingNonAutomaticOpenTelemetry;
        this.avoidExecutionInterceptorsOnClientsUsedByPowerTools = avoidExecutionInterceptorsOnClientsUsedByPowerTools;
        this.awsRegion = Region.of((String)System.getenv("AWS_REGION"));
        this.sdkHttpClient = AwsCrtHttpClient.builder().maxConcurrency(Integer.valueOf(100)).build();
        this.awsCredentialsProvider = System.getenv("AWS_CONTAINER_CREDENTIALS_FULL_URI") == null ? EnvironmentVariableCredentialsProvider.create() : ContainerCredentialsProvider.builder().build();
    }

    public AwsCredentialsProvider getAwsCredentialsProvider() {
        return this.awsCredentialsProvider;
    }

    public KmsClient getKMSClient() {
        if (null == this.kmsClient) {
            KmsClientBuilder kmsClientBuilder = (KmsClientBuilder)((KmsClientBuilder)((KmsClientBuilder)((KmsClientBuilder)KmsClient.builder().region(this.awsRegion)).httpClient(this.sdkHttpClient)).credentialsProvider(this.awsCredentialsProvider)).defaultsMode(DEFAULTS_MODE);
            if (this.addOpenTelemetryExecutionInterceptors) {
                kmsClientBuilder.overrideConfiguration((ClientOverrideConfiguration)ClientOverrideConfiguration.builder().addExecutionInterceptor(AwsSdkTelemetry.create((OpenTelemetry)GlobalOpenTelemetry.get()).newExecutionInterceptor()).build());
            }
            this.kmsClient = (KmsClient)kmsClientBuilder.build();
        }
        return this.kmsClient;
    }

    public SqsClient getSqsClient() {
        if (null == this.sqsClient) {
            SqsClientBuilder sqsClientBuilder = (SqsClientBuilder)((SqsClientBuilder)((SqsClientBuilder)((SqsClientBuilder)SqsClient.builder().region(this.awsRegion)).httpClient(this.sdkHttpClient)).credentialsProvider(this.awsCredentialsProvider)).defaultsMode(DEFAULTS_MODE);
            if (this.addOpenTelemetryExecutionInterceptors) {
                OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
                AwsSdkTelemetry awsSdkTelemetry = AwsSdkTelemetry.create((OpenTelemetry)openTelemetry);
                sqsClientBuilder.overrideConfiguration((ClientOverrideConfiguration)ClientOverrideConfiguration.builder().addExecutionInterceptor(awsSdkTelemetry.newExecutionInterceptor()).build());
                this.sqsClient = awsSdkTelemetry.wrap((SqsClient)sqsClientBuilder.build());
            } else {
                this.sqsClient = (SqsClient)sqsClientBuilder.build();
            }
        }
        return this.sqsClient;
    }

    public DynamoDbEnhancedClient getDynamoDbEnhancedClient() {
        if (null == this.dynamoDbEnhancedClient) {
            DynamoDbClientBuilder dynamoDbClientBuilder = (DynamoDbClientBuilder)((DynamoDbClientBuilder)((DynamoDbClientBuilder)((DynamoDbClientBuilder)DynamoDbClient.builder().region(this.awsRegion)).httpClient(this.sdkHttpClient)).credentialsProvider(this.awsCredentialsProvider)).defaultsMode(DEFAULTS_MODE);
            if (this.addOpenTelemetryExecutionInterceptors) {
                dynamoDbClientBuilder.overrideConfiguration((ClientOverrideConfiguration)ClientOverrideConfiguration.builder().addExecutionInterceptor(AwsSdkTelemetry.create((OpenTelemetry)GlobalOpenTelemetry.get()).newExecutionInterceptor()).build());
            }
            DynamoDbClient dynamoDbClient = (DynamoDbClient)dynamoDbClientBuilder.build();
            this.dynamoDbEnhancedClient = DynamoDbEnhancedClient.builder().dynamoDbClient(dynamoDbClient).build();
        }
        return this.dynamoDbEnhancedClient;
    }

    public SsmClient getSsmClient() {
        if (null == this.ssmClient) {
            SsmClientBuilder ssmClientBuilder = (SsmClientBuilder)((SsmClientBuilder)((SsmClientBuilder)((SsmClientBuilder)SsmClient.builder().region(this.awsRegion)).httpClient(this.sdkHttpClient)).credentialsProvider(this.awsCredentialsProvider)).defaultsMode(DEFAULTS_MODE);
            if (this.addOpenTelemetryExecutionInterceptors && !this.avoidExecutionInterceptorsOnClientsUsedByPowerTools) {
                ssmClientBuilder.overrideConfiguration((ClientOverrideConfiguration)ClientOverrideConfiguration.builder().addExecutionInterceptor(AwsSdkTelemetry.create((OpenTelemetry)GlobalOpenTelemetry.get()).newExecutionInterceptor()).build());
            }
            this.ssmClient = (SsmClient)ssmClientBuilder.build();
        }
        return this.ssmClient;
    }

    public SSMProvider getSSMProvider() {
        if (null == this.ssmProvider) {
            int maxAge = this.generateRandomMaxAgeInSeconds();
            LOGGER.info("PowerTools SSMProvider defaultMaxAge selected as {} seconds", (Object)maxAge);
            this.ssmProvider = ParamManager.getSsmProvider((SsmClient)this.getSsmClient()).defaultMaxAge(maxAge, ChronoUnit.SECONDS);
        }
        return this.ssmProvider;
    }

    public SecretsProvider getSecretsProvider() {
        if (null == this.secretsProvider) {
            int maxAge = this.generateRandomMaxAgeInSeconds();
            LOGGER.info("PowerTools SecretsProvider defaultMaxAge selected as {} seconds", (Object)maxAge);
            this.secretsProvider = ParamManager.getSecretsProvider((SecretsManagerClient)this.getSecretsManagerClient()).defaultMaxAge(maxAge, ChronoUnit.SECONDS);
        }
        return this.secretsProvider;
    }

    private int generateRandomMaxAgeInSeconds() {
        int minCacheAgeFallback = 5;
        int maxCacheAgeFallback = 15;
        int cacheMinMinutes = System.getenv(CONFIG_SERVICE_SSM_OPTIMIZED_CACHE_AGE_MIN_MINUTES) != null ? Integer.parseInt(System.getenv(CONFIG_SERVICE_SSM_OPTIMIZED_CACHE_AGE_MIN_MINUTES)) : minCacheAgeFallback;
        int cacheMaxMinutes = System.getenv(CONFIG_SERVICE_SSM_OPTIMIZED_CACHE_AGE_MAX_MINUTES) != null ? Integer.parseInt(System.getenv(CONFIG_SERVICE_SSM_OPTIMIZED_CACHE_AGE_MAX_MINUTES)) : maxCacheAgeFallback;
        int minCacheSeconds = cacheMinMinutes * 60;
        int maxCacheSeconds = cacheMaxMinutes * 60;
        return ThreadLocalRandom.current().nextInt(maxCacheSeconds - minCacheSeconds + 1) + minCacheSeconds;
    }

    public SecretsManagerClient getSecretsManagerClient() {
        if (null == this.secretsManagerClient) {
            SecretsManagerClientBuilder secretsManagerClientBuilder = (SecretsManagerClientBuilder)((SecretsManagerClientBuilder)((SecretsManagerClientBuilder)((SecretsManagerClientBuilder)SecretsManagerClient.builder().region(this.awsRegion)).httpClient(this.sdkHttpClient)).credentialsProvider(this.awsCredentialsProvider)).defaultsMode(DEFAULTS_MODE);
            if (this.addOpenTelemetryExecutionInterceptors) {
                secretsManagerClientBuilder.overrideConfiguration((ClientOverrideConfiguration)ClientOverrideConfiguration.builder().addExecutionInterceptor(AwsSdkTelemetry.create((OpenTelemetry)GlobalOpenTelemetry.get()).newExecutionInterceptor()).build());
            }
            this.secretsManagerClient = (SecretsManagerClient)secretsManagerClientBuilder.build();
        }
        return this.secretsManagerClient;
    }

    public AcmClient getAcmClient() {
        if (null == this.acmClient) {
            AcmClientBuilder acmClientBuilder = (AcmClientBuilder)((AcmClientBuilder)((AcmClientBuilder)((AcmClientBuilder)AcmClient.builder().region(this.awsRegion)).httpClient(this.sdkHttpClient)).credentialsProvider(this.awsCredentialsProvider)).defaultsMode(DEFAULTS_MODE);
            if (this.addOpenTelemetryExecutionInterceptors) {
                acmClientBuilder.overrideConfiguration((ClientOverrideConfiguration)ClientOverrideConfiguration.builder().addExecutionInterceptor(AwsSdkTelemetry.create((OpenTelemetry)GlobalOpenTelemetry.get()).newExecutionInterceptor()).build());
            }
            this.acmClient = (AcmClient)acmClientBuilder.build();
        }
        return this.acmClient;
    }
}

