/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.di.ipv.cri.common.library.util;

import com.nimbusds.oauth2.sdk.util.StringUtils;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.amazon.cloudwatchlogs.emf.logger.MetricsLogger;
import software.amazon.cloudwatchlogs.emf.model.DimensionSet;
import software.amazon.cloudwatchlogs.emf.model.Unit;
import software.amazon.lambda.powertools.logging.LoggingUtils;
import software.amazon.lambda.powertools.metrics.MetricsUtils;

public class EventProbe {
    private static final String GOVUK_SIGNIN_JOURNEY_ID = "govuk_signin_journey_id";
    private static final Logger LOGGER = LogManager.getLogger();
    private final MetricsLogger metricsLogger;

    public EventProbe() {
        this(MetricsUtils.metricsLogger());
    }

    public EventProbe(MetricsLogger metricsLogger) {
        this.metricsLogger = metricsLogger;
    }

    public EventProbe log(Level level, Throwable throwable) {
        LOGGER.log(level, throwable.getMessage(), throwable);
        if (level == Level.ERROR) {
            this.logErrorCause(throwable);
        }
        return this;
    }

    public EventProbe log(Level level, String message) {
        if (LOGGER.isEnabled(level)) {
            LOGGER.log(level, message);
        }
        return this;
    }

    private void logErrorCause(Throwable throwable) {
        Throwable cause = throwable.getCause();
        if (Objects.nonNull(cause)) {
            LOGGER.error(cause.getMessage(), cause);
            this.logErrorCause(cause);
        }
    }

    public EventProbe counterMetric(String key) {
        this.metricsLogger.putMetric(key, 1.0);
        return this;
    }

    public EventProbe counterMetric(String key, double value) {
        this.metricsLogger.putMetric(key, value);
        return this;
    }

    public EventProbe counterMetric(String key, double value, Unit unit) {
        this.metricsLogger.putMetric(key, value, unit);
        return this;
    }

    public EventProbe auditEvent(Object event) {
        LOGGER.info(() -> "sending audit event " + String.valueOf(event));
        return this;
    }

    public EventProbe addFieldToLoggingContext(String name, String value) {
        LoggingUtils.appendKey((String)name, (String)value);
        return this;
    }

    public EventProbe addJourneyIdToLoggingContext(String journeyId) {
        if (StringUtils.isNotBlank((CharSequence)journeyId)) {
            this.addFieldToLoggingContext(GOVUK_SIGNIN_JOURNEY_ID, journeyId);
        }
        return this;
    }

    public void addDimensions(Map<String, String> dimensions) {
        if (dimensions != null) {
            DimensionSet dimensionSet = new DimensionSet();
            dimensions.forEach((arg_0, arg_1) -> ((DimensionSet)dimensionSet).addDimension(arg_0, arg_1));
            this.metricsLogger.putDimensions(dimensionSet);
        }
    }
}

