/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.di.ipv.cri.common.library.util;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.impl.ECDSA;
import com.nimbusds.jose.jca.JCAContext;
import com.nimbusds.jose.util.Base64URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.Set;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.KmsClientBuilder;
import software.amazon.awssdk.services.kms.model.MessageType;
import software.amazon.awssdk.services.kms.model.SignRequest;
import software.amazon.awssdk.services.kms.model.SignResponse;
import software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec;
import uk.gov.di.ipv.cri.common.library.annotations.ExcludeFromGeneratedCoverageReport;

public class KMSSigner
implements JWSSigner {
    private final KmsClient kmsClient;
    private final JCAContext jcaContext = new JCAContext();
    private final String keyId;

    @ExcludeFromGeneratedCoverageReport
    public KMSSigner(String keyId) {
        this.keyId = keyId;
        this.kmsClient = (KmsClient)((KmsClientBuilder)((KmsClientBuilder)KmsClient.builder().region(Region.of((String)System.getenv("AWS_REGION")))).credentialsProvider((AwsCredentialsProvider)EnvironmentVariableCredentialsProvider.create())).build();
    }

    public KMSSigner(String keyId, KmsClient kmsClient) {
        this.keyId = keyId;
        this.kmsClient = kmsClient;
    }

    public Base64URL sign(JWSHeader header, byte[] signingInput) throws JOSEException {
        Objects.requireNonNull(signingInput, "Signing input must not be null");
        SignResponse signResponse = this.kmsClient.sign((SignRequest)SignRequest.builder().signingAlgorithm(SigningAlgorithmSpec.ECDSA_SHA_256.toString()).keyId(this.keyId).message(SdkBytes.fromByteArray((byte[])this.getSigningInputBytes(signingInput))).messageType(MessageType.DIGEST).build());
        byte[] concatSignature = ECDSA.transcodeSignatureToConcat((byte[])signResponse.signature().asByteArray(), (int)ECDSA.getSignatureByteArrayLength((JWSAlgorithm)JWSAlgorithm.ES256));
        return Base64URL.encode((byte[])concatSignature);
    }

    private byte[] getSigningInputBytes(byte[] signingInput) throws JOSEException {
        byte[] signingInputHash;
        try {
            signingInputHash = MessageDigest.getInstance("SHA-256").digest(signingInput);
        }
        catch (NoSuchAlgorithmException e) {
            throw new JOSEException(e.getMessage());
        }
        return signingInputHash;
    }

    public Set<JWSAlgorithm> supportedJWSAlgorithms() {
        return Set.of(JWSAlgorithm.ES256);
    }

    public JCAContext getJCAContext() {
        return this.jcaContext;
    }
}

