/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.di.ipv.cri.common.library.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class ListUtil {
    private ListUtil() {
    }

    public static <T> T getOneItemOrThrowError(List<T> list) throws IllegalArgumentException {
        if (Objects.isNull(list) || list.isEmpty()) {
            throw new IllegalArgumentException("No items found");
        }
        if (list.size() > 1) {
            throw new IllegalArgumentException("More than one item found");
        }
        return list.get(0);
    }

    public static <T> List<List<T>> split(List<T> list, int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("Batch size must be greater than 0");
        }
        ArrayList<List<T>> batches = new ArrayList<List<T>>();
        for (int idx = 0; idx < list.size(); idx += batchSize) {
            batches.add(list.subList(idx, Math.min(list.size(), idx + batchSize)));
        }
        return batches;
    }

    public static <T, U extends Comparable<? super U>> List<T> except(List<T> source, List<T> except, Function<? super T, ? extends U> mapper) {
        return ListUtil.except(source, except, Comparator.comparing(mapper));
    }

    public static <T> List<T> except(List<T> source, List<T> except, Comparator<T> comparator) {
        return source.stream().filter(element -> !ListUtil.contains(except, element, comparator)).collect(Collectors.toList());
    }

    public static <T, U extends Comparable<? super U>> void exclude(List<T> source, List<T> except, Function<? super T, ? extends U> mapper) {
        ListUtil.exclude(source, except, Comparator.comparing(mapper));
    }

    public static <T> void exclude(List<T> source, List<T> except, Comparator<T> comparator) {
        source.removeIf(element -> ListUtil.contains(except, element, comparator));
    }

    public static <T, U extends Comparable<? super U>> void mergeDistinct(List<T> source, List<T> merge, Function<? super T, ? extends U> mapper) {
        ListUtil.mergeDistinct(source, merge, Comparator.comparing(mapper));
    }

    public static <T> void mergeDistinct(List<T> source, List<T> merge, Comparator<T> comparator) {
        ListUtil.exclude(source, merge, comparator);
        source.addAll(merge);
    }

    public static <T> boolean contains(List<T> list, T object, Comparator<T> comparator) {
        return list.stream().anyMatch(element -> ListUtil.objectsEqual(element, object, comparator));
    }

    private static <T> boolean objectsEqual(T a, T b, Comparator<T> comparator) {
        return comparator.compare(a, b) == 0;
    }
}

