/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.di.ipv.cri.common.library.util.retry;

import java.util.function.Predicate;

public class RetryConfig {
    private final int maxAttempts;
    private final long delayBetweenAttempts;
    private final boolean exponentiallyRetry;
    private final Predicate<Exception> abortCondition;

    private RetryConfig(Builder builder) {
        this.maxAttempts = builder.maxAttempts;
        this.delayBetweenAttempts = builder.delayBetweenAttempts;
        this.exponentiallyRetry = builder.exponentiallyRetry;
        this.abortCondition = builder.abortCondition;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public long getDelayBetweenAttempts() {
        return this.delayBetweenAttempts;
    }

    public boolean isExponentiallyRetry() {
        return this.exponentiallyRetry;
    }

    public Predicate<Exception> getAbortCondition() {
        return this.abortCondition;
    }

    public static class Builder {
        private int maxAttempts = 3;
        private long delayBetweenAttempts = 1000L;
        private boolean exponentiallyRetry = false;
        private Predicate<Exception> abortCondition;

        public Builder maxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Builder delayBetweenAttempts(long delayBetweenAttemptsInMs) {
            this.delayBetweenAttempts = delayBetweenAttemptsInMs;
            return this;
        }

        public Builder exponentiallyRetry(boolean exponentiallyRetry) {
            this.exponentiallyRetry = exponentiallyRetry;
            return this;
        }

        public Builder abortOn(Predicate<Exception> condition) {
            this.abortCondition = condition;
            return this;
        }

        public RetryConfig build() {
            return new RetryConfig(this);
        }
    }
}

