/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.di.ipv.cri.common.library.util.retry;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.gov.di.ipv.cri.common.library.exception.RetryException;
import uk.gov.di.ipv.cri.common.library.util.retry.RetryConfig;
import uk.gov.di.ipv.cri.common.library.util.retry.Retryable;

public class RetryManager {
    private static final Logger LOGGER = LogManager.getLogger(RetryManager.class);

    private RetryManager() {
        throw new IllegalStateException("Static class");
    }

    public static <T> T execute(RetryConfig retryConfig, Retryable<T> retryable) {
        int maxAttempts = retryConfig.getMaxAttempts();
        for (int attempt = 0; attempt < maxAttempts; ++attempt) {
            try {
                LOGGER.info("Retrying attempt {} of {}", (Object)attempt, (Object)maxAttempts);
                if (attempt > 0) {
                    long start = System.currentTimeMillis();
                    long sleepDuration = RetryManager.calculateSleepDuration(retryConfig, attempt);
                    LOGGER.info("Sleeping for {}ms at {}", (Object)sleepDuration, (Object)System.currentTimeMillis());
                    Thread.sleep(sleepDuration);
                    long elapsed = System.currentTimeMillis() - start;
                    LOGGER.info("Slept for {}ms", (Object)elapsed);
                }
                T result = retryable.execute();
                LOGGER.info("Retry succeeded on attempt {}", (Object)attempt);
                return result;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new RetryException(ex);
            }
            catch (Exception e) {
                LOGGER.error("Retry attempt {} failed", (Object)attempt, (Object)e);
                if (!RetryManager.shouldAbortRetry(retryConfig, e, attempt)) continue;
                throw e;
            }
        }
        throw new RetryException();
    }

    private static boolean shouldAbortRetry(RetryConfig retryConfig, Exception e, int attempt) {
        return attempt == retryConfig.getMaxAttempts() - 1 || retryConfig.getAbortCondition() != null && retryConfig.getAbortCondition().test(e);
    }

    private static long calculateSleepDuration(RetryConfig retryConfig, int attempt) {
        if (attempt == 0) {
            return 0L;
        }
        long duration = retryConfig.getDelayBetweenAttempts();
        if (retryConfig.isExponentiallyRetry()) {
            duration = (long)((double)duration * Math.pow(2.0, attempt));
        }
        return duration;
    }
}

