/*
 * Decompiled with CFR 0.152.
 */
package event.logging;

import event.logging.EventAction;
import event.logging.LoggedOutcome;
import java.util.Objects;

public class ComplexLoggedOutcome<T_RESULT, T_EVENT_ACTION extends EventAction> {
    final LoggedOutcome<T_RESULT> loggedOutcome;
    final T_EVENT_ACTION eventAction;

    private ComplexLoggedOutcome(T_RESULT result, T_EVENT_ACTION eventAction, boolean wasSuccessful, String outcomeDescription) {
        this.loggedOutcome = LoggedOutcome.of(result, wasSuccessful, outcomeDescription);
        this.eventAction = (EventAction)Objects.requireNonNull(eventAction);
    }

    private ComplexLoggedOutcome(LoggedOutcome<T_RESULT> loggedOutcome, T_EVENT_ACTION eventAction) {
        this.loggedOutcome = loggedOutcome;
        this.eventAction = eventAction;
    }

    public static <T_RESULT, T_EVENT_ACTION extends EventAction> ComplexLoggedOutcome<T_RESULT, T_EVENT_ACTION> of(LoggedOutcome<T_RESULT> loggedOutcome, T_EVENT_ACTION eventAction) {
        return new ComplexLoggedOutcome<T_RESULT, T_EVENT_ACTION>(loggedOutcome, eventAction);
    }

    public static <T_RESULT, T_EVENT_ACTION extends EventAction> ComplexLoggedOutcome<T_RESULT, T_EVENT_ACTION> success(T_RESULT result, T_EVENT_ACTION eventAction) {
        return new ComplexLoggedOutcome<T_RESULT, T_EVENT_ACTION>(result, eventAction, true, null);
    }

    public static <T_EVENT_ACTION extends EventAction> ComplexLoggedOutcome<Void, T_EVENT_ACTION> success(T_EVENT_ACTION eventAction) {
        return new ComplexLoggedOutcome<Void, T_EVENT_ACTION>(null, eventAction, true, null);
    }

    public static <T_RESULT, T_EVENT_ACTION extends EventAction> ComplexLoggedOutcome<T_RESULT, T_EVENT_ACTION> failure(T_RESULT result, T_EVENT_ACTION eventAction, String outcomeDescription) {
        return new ComplexLoggedOutcome<T_RESULT, T_EVENT_ACTION>(result, eventAction, false, outcomeDescription);
    }

    public static <T_EVENT_ACTION extends EventAction> ComplexLoggedOutcome<Void, T_EVENT_ACTION> failure(T_EVENT_ACTION eventAction, String outcomeDescription) {
        return new ComplexLoggedOutcome<Void, T_EVENT_ACTION>(null, eventAction, false, outcomeDescription);
    }

    public T_RESULT getResult() {
        return this.loggedOutcome.getResult();
    }

    public T_EVENT_ACTION getEventAction() {
        return this.eventAction;
    }

    public String getOutcomeDescription() {
        return this.loggedOutcome.getOutcomeDescription();
    }

    public boolean wasSuccessful() {
        return this.loggedOutcome.wasSuccessful();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComplexLoggedOutcome that = (ComplexLoggedOutcome)o;
        return Objects.equals(this.loggedOutcome, that.loggedOutcome) && Objects.equals(this.eventAction, that.eventAction);
    }

    public int hashCode() {
        return Objects.hash(this.loggedOutcome, this.eventAction);
    }

    public String toString() {
        return "ComplexLoggedOutcome{loggedOutcome=" + this.loggedOutcome + ", eventAction=" + this.eventAction + '}';
    }
}

